/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc;

import java.io.IOException;
import java.security.Permission;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.naming.NamingException;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.database.utils.JDBCUtils;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.security.JCRRuntimePermissions;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.checker.DummyRepair;
import org.exoplatform.services.jcr.impl.checker.EarlierVersionsRemover;
import org.exoplatform.services.jcr.impl.checker.InspectionQuery;
import org.exoplatform.services.jcr.impl.checker.InspectionReport;
import org.exoplatform.services.jcr.impl.checker.NodeRemover;
import org.exoplatform.services.jcr.impl.checker.PropertyRemover;
import org.exoplatform.services.jcr.impl.checker.RootAsParentAssigner;
import org.exoplatform.services.jcr.impl.checker.ValueRecordsRemover;
import org.exoplatform.services.jcr.impl.core.lock.LockTableHandler;
import org.exoplatform.services.jcr.impl.core.lock.cacheable.AbstractCacheableLockManager;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeDataManagerImpl;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCWorkspaceDataContainer;
import org.exoplatform.services.jcr.impl.storage.value.ValueDataNotFoundException;
import org.exoplatform.services.jcr.impl.storage.value.ValueStorageNotFoundException;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerHelper;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.jcr.storage.value.ValueIOChannel;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCWorkspaceDataContainerChecker {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.JDBCWorkspaceDataContainerChecker");
    protected final JDBCWorkspaceDataContainer jdbcDataContainer;
    protected final ValueStoragePluginProvider vsPlugin;
    protected final WorkspaceEntry workspaceEntry;
    protected final InspectionReport report;
    private InspectionQuery vsInspectionQuery;
    private InspectionQuery lockInspectionQuery;
    private List<InspectionQuery> itemsInspectionQuery = new ArrayList<InspectionQuery>();
    private LockTableHandler lockHandler;
    private NodeTypeDataManagerImpl nodeTypeManager;

    public JDBCWorkspaceDataContainerChecker(JDBCWorkspaceDataContainer jdbcDataContainer, AbstractCacheableLockManager lockManager, ValueStoragePluginProvider vsPlugin, WorkspaceEntry workspaceEntry, NodeTypeDataManagerImpl nodeTypeManager, InspectionReport report) {
        this.jdbcDataContainer = jdbcDataContainer;
        this.vsPlugin = vsPlugin;
        this.workspaceEntry = workspaceEntry;
        this.report = report;
        this.lockHandler = lockManager.getLockTableHandler();
        this.nodeTypeManager = nodeTypeManager;
        this.initInspectionQueries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkLocksInDataBase(boolean autoRepair) {
        SecurityHelper.validateSecurityPermission((Permission)JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        Connection jdbcConnection = null;
        try {
            try {
                jdbcConnection = this.jdbcDataContainer.getConnectionFactory().getJdbcConnection();
                preparedStatement = jdbcConnection.prepareStatement(this.lockInspectionQuery.getStatement());
                resultSet = preparedStatement.executeQuery();
                HashSet<String> lockedInJCRITEM = new HashSet<String>();
                while (resultSet.next()) {
                    lockedInJCRITEM.add(this.removeWorkspacePrefix(resultSet.getString("PARENT_ID")));
                }
                Set<String> lockedInJCRLOCK = this.lockHandler.getLockedNodesIds();
                this.checkConsistencyInJCRITEM(lockedInJCRITEM, lockedInJCRLOCK, autoRepair);
                this.checkConsistencyInJCRLOCK(lockedInJCRITEM, lockedInJCRLOCK, autoRepair);
            }
            catch (SQLException e) {
                this.logExceptionAndSetInconsistency("Unexpected exception during LOCK DB checking.", e);
                Object var8_12 = null;
                JDBCUtils.freeResources(resultSet, (Statement)preparedStatement, (Connection)jdbcConnection);
                return;
            }
            catch (NamingException e) {
                this.logExceptionAndSetInconsistency("Unexpected exception during LOCK DB checking.", e);
                Object var8_13 = null;
                JDBCUtils.freeResources(resultSet, (Statement)preparedStatement, (Connection)jdbcConnection);
                return;
            }
            catch (RepositoryConfigurationException e) {
                this.logExceptionAndSetInconsistency("Unexpected exception during LOCK DB checking.", e);
                Object var8_14 = null;
                JDBCUtils.freeResources(resultSet, (Statement)preparedStatement, (Connection)jdbcConnection);
                return;
            }
            catch (RepositoryException e) {
                this.logExceptionAndSetInconsistency("Unexpected exception during LOCK DB checking.", e);
                Object var8_15 = null;
                JDBCUtils.freeResources(resultSet, (Statement)preparedStatement, (Connection)jdbcConnection);
                return;
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_16 = null;
            JDBCUtils.freeResources(resultSet, preparedStatement, (Connection)jdbcConnection);
            throw throwable;
        }
        JDBCUtils.freeResources((ResultSet)resultSet, (Statement)preparedStatement, (Connection)jdbcConnection);
    }

    private void checkConsistencyInJCRITEM(Set<String> lockedInJCRITEM, Set<String> lockedInJCRLOCK, boolean autoRepair) throws RepositoryException, SQLException {
        for (String nodeId : lockedInJCRITEM) {
            if (lockedInJCRLOCK.contains(nodeId)) continue;
            this.logBrokenObjectAndSetInconsistency("Lock exists in ITEM table but not in LOCK table. Node UUID: " + nodeId);
            if (!autoRepair) continue;
            WorkspaceStorageConnection conn = this.jdbcDataContainer.openConnection();
            try {
                NodeData parent = (NodeData)conn.getItemData(nodeId);
                PropertyData prop = (PropertyData)conn.getItemData(parent, new QPathEntry(Constants.JCR_LOCKISDEEP, 0), ItemType.PROPERTY);
                conn.delete(prop);
                prop = (PropertyData)conn.getItemData(parent, new QPathEntry(Constants.JCR_LOCKOWNER, 0), ItemType.PROPERTY);
                conn.delete(prop);
                conn.commit();
                this.logComment("Lock has been removed form ITEM table. Node UUID: " + nodeId);
            }
            catch (RepositoryException e) {
                conn.rollback();
                throw e;
            }
        }
    }

    private void checkConsistencyInJCRLOCK(Set<String> lockedInJCRITEM, Set<String> lockedInJCRLOCK, boolean autoRepair) throws NamingException, RepositoryConfigurationException, SQLException {
        for (String nodeId : lockedInJCRLOCK) {
            if (lockedInJCRITEM.contains(nodeId)) continue;
            this.logBrokenObjectAndSetInconsistency("Lock exists in LOCK table but not in ITEM table. Node UUID: " + nodeId);
            if (!autoRepair) continue;
            this.lockHandler.removeLockedNode(nodeId);
            this.logComment("Lock has been removed form LOCK table. Node UUID: " + nodeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkDataBase(boolean autoRepair) {
        SecurityHelper.validateSecurityPermission((Permission)JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        Connection jdbcConn = null;
        try {
            try {
                jdbcConn = this.jdbcDataContainer.getConnectionFactory().getJdbcConnection();
                for (InspectionQuery query : this.itemsInspectionQuery) {
                    Object var9_10;
                    PreparedStatement st = null;
                    ResultSet resultSet = null;
                    try {
                        st = jdbcConn.prepareStatement(query.getStatement());
                        resultSet = st.executeQuery();
                        if (resultSet.next()) {
                            this.logDescription(query.getDescription());
                            do {
                                this.logBrokenObjectAndSetInconsistency(this.getBrokenObject(resultSet, query.getFieldNames()));
                                if (!autoRepair) continue;
                                try {
                                    query.getRepair().doRepair(resultSet);
                                    this.logComment("Inconsistency has been fixed");
                                }
                                catch (SQLException e) {
                                    this.logExceptionAndSetInconsistency("Inconsistency can not been fixed", e);
                                }
                            } while (resultSet.next());
                        }
                        var9_10 = null;
                    }
                    catch (Throwable throwable) {
                        var9_10 = null;
                        JDBCUtils.freeResources((ResultSet)resultSet, (Statement)st, null);
                        throw throwable;
                    }
                    JDBCUtils.freeResources((ResultSet)resultSet, (Statement)st, null);
                }
                Object var11_12 = null;
            }
            catch (SQLException e) {
                this.logExceptionAndSetInconsistency("Unexpected exception during DB checking.", e);
                Object var11_13 = null;
                JDBCUtils.freeResources(null, null, (Connection)jdbcConn);
                return;
            }
            catch (RepositoryException e) {
                this.logExceptionAndSetInconsistency("Unexpected exception during DB checking.", e);
                Object var11_14 = null;
                JDBCUtils.freeResources(null, null, (Connection)jdbcConn);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            JDBCUtils.freeResources(null, null, (Connection)jdbcConn);
            throw throwable;
        }
        JDBCUtils.freeResources(null, null, (Connection)jdbcConn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkValueStorage(boolean autoRepair) {
        SecurityHelper.validateSecurityPermission((Permission)JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        Connection connection = null;
        PreparedStatement st = null;
        ResultSet resultSet = null;
        try {
            block11: {
                try {
                    connection = this.jdbcDataContainer.getConnectionFactory().getJdbcConnection();
                    st = connection.prepareStatement(this.vsInspectionQuery.getStatement());
                    resultSet = st.executeQuery();
                    if (!resultSet.next()) break block11;
                    this.logDescription("ValueData not found inconsistency");
                    do {
                        Object var9_12;
                        String storageDesc = resultSet.getString("STORAGE_DESC");
                        ValueIOChannel channel = null;
                        try {
                            try {
                                channel = this.getIOChannel(storageDesc);
                                this.doCheckAndRepairValueData(channel, resultSet, autoRepair);
                            }
                            catch (IOException e) {
                                this.logExceptionAndSetInconsistency("Unexpected exception during checking.", e);
                                var9_12 = null;
                                if (channel == null) continue;
                                channel.close();
                                continue;
                            }
                            catch (SQLException e) {
                                this.logExceptionAndSetInconsistency("Unexpected exception during checking.", e);
                                var9_12 = null;
                                if (channel == null) continue;
                                channel.close();
                                continue;
                            }
                            var9_12 = null;
                            if (channel == null) continue;
                            channel.close();
                        }
                        catch (Throwable throwable) {
                            var9_12 = null;
                            if (channel == null) throw throwable;
                            channel.close();
                            throw throwable;
                        }
                    } while (resultSet.next());
                }
                catch (SQLException e) {
                    this.logExceptionAndSetInconsistency("Unexpected exception during checking.", e);
                    Object var11_15 = null;
                    JDBCUtils.freeResources(resultSet, (Statement)st, (Connection)connection);
                    return;
                }
                catch (RepositoryException e) {
                    this.logExceptionAndSetInconsistency("Unexpected exception during checking.", e);
                    Object var11_16 = null;
                    JDBCUtils.freeResources(resultSet, (Statement)st, (Connection)connection);
                    return;
                }
            }
            Object var11_14 = null;
            JDBCUtils.freeResources((ResultSet)resultSet, (Statement)st, (Connection)connection);
            return;
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            JDBCUtils.freeResources(resultSet, st, (Connection)connection);
            throw throwable;
        }
    }

    private ValueIOChannel getIOChannel(String storageDesc) throws IOException {
        ValueIOChannel channel = null;
        try {
            channel = this.vsPlugin.getChannel(storageDesc);
        }
        catch (ValueStorageNotFoundException e) {
            this.logExceptionAndSetInconsistency("ValueStorage " + storageDesc + " not found: " + e.getMessage(), (Throwable)((Object)e));
        }
        return channel;
    }

    private void doCheckAndRepairValueData(ValueIOChannel channel, ResultSet resultSet, boolean autoRepair) throws IOException, SQLException {
        block4: {
            String propertyId = this.removeWorkspacePrefix(resultSet.getString("PROPERTY_ID"));
            int orderNumber = resultSet.getInt("ORDER_NUM");
            try {
                channel.checkValueData(propertyId, orderNumber);
            }
            catch (ValueDataNotFoundException e) {
                this.logBrokenObjectAndSetInconsistency(this.getBrokenObject(resultSet, this.vsInspectionQuery.getFieldNames()));
                if (!autoRepair) break block4;
                try {
                    channel.repairValueData(propertyId, orderNumber);
                    this.logComment("ValueData has been repaired. New empty file is created.");
                }
                catch (IOException e2) {
                    this.logExceptionAndSetInconsistency("Can not repair value data: " + e.getMessage(), (Throwable)((Object)e));
                }
            }
        }
    }

    private String removeWorkspacePrefix(String str) {
        return this.jdbcDataContainer.containerConfig.dbStructureType.isMultiDatabase() ? str : str.substring(this.jdbcDataContainer.containerConfig.containerName.length());
    }

    private String getBrokenObject(ResultSet resultSet, String[] fieldNames) {
        StringBuilder record = new StringBuilder();
        for (String fieldName : fieldNames) {
            record.append(fieldName);
            record.append('=');
            try {
                record.append(resultSet.getString(fieldName));
            }
            catch (SQLException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            record.append(' ');
        }
        return record.toString();
    }

    private void logBrokenObjectAndSetInconsistency(String brokenObject) {
        try {
            this.report.logBrokenObjectAndSetInconsistency(brokenObject);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void logComment(String message) {
        try {
            this.report.logComment(message);
        }
        catch (IOException e1) {
            LOG.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    private void logDescription(String description) {
        try {
            this.report.logDescription(description);
        }
        catch (IOException e1) {
            LOG.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    private void logExceptionAndSetInconsistency(String message, Throwable e) {
        try {
            this.report.logExceptionAndSetInconsistency(message, e);
        }
        catch (IOException e1) {
            LOG.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    private void initInspectionQueries() {
        String statement;
        String itemTable = DBInitializerHelper.getItemTableName(this.jdbcDataContainer.containerConfig);
        String valueTable = DBInitializerHelper.getValueTableName(this.jdbcDataContainer.containerConfig);
        String refTable = DBInitializerHelper.getRefTableName(this.jdbcDataContainer.containerConfig);
        boolean singleDatabase = this.jdbcDataContainer.containerConfig.dbStructureType == JDBCDataContainerConfig.DatabaseStructureType.SINGLE;
        this.vsInspectionQuery = new InspectionQuery(singleDatabase ? "select V.PROPERTY_ID, V.ORDER_NUM, V.STORAGE_DESC from " + valueTable + " V, " + itemTable + " I" + " where I.CONTAINER_NAME='" + this.jdbcDataContainer.containerConfig.containerName + "' and V.PROPERTY_ID = I.ID and STORAGE_DESC is not null" : "select PROPERTY_ID, ORDER_NUM, STORAGE_DESC from " + valueTable + " where STORAGE_DESC is not null", new String[]{"PROPERTY_ID", "ORDER_NUM", "STORAGE_DESC"}, "Items with value data stored in value storage", new DummyRepair());
        this.lockInspectionQuery = new InspectionQuery(singleDatabase ? "select distinct PARENT_ID from " + itemTable + " WHERE CONTAINER_NAME='" + this.jdbcDataContainer.containerConfig.containerName + "'" + " AND I_CLASS=2 and (NAME='[http://www.jcp.org/jcr/1.0]lockOwner'" + " OR NAME='[http://www.jcp.org/jcr/1.0]lockIsDeep')" : "select distinct PARENT_ID from " + itemTable + " where I_CLASS=2 AND" + " (NAME='[http://www.jcp.org/jcr/1.0]lockOwner' OR NAME='[http://www.jcp.org/jcr/1.0]lockIsDeep')", new String[]{"PARENT_ID"}, "Items which have jcr:lockOwner and jcr:lockIsDeep properties", new DummyRepair());
        this.itemsInspectionQuery.add(new InspectionQuery(singleDatabase ? "select * from " + itemTable + " I where I.CONTAINER_NAME='" + this.jdbcDataContainer.containerConfig.containerName + "' and NOT EXISTS(select * from " + itemTable + " P where P.ID = I.PARENT_ID)" : "select * from " + itemTable + " I where NOT EXISTS(select * from " + itemTable + " P where P.ID = I.PARENT_ID)", new String[]{"ID", "PARENT_ID", "NAME", "I_CLASS"}, "Items that do not have parent nodes", new RootAsParentAssigner(this.jdbcDataContainer.getConnectionFactory(), this.jdbcDataContainer.containerConfig)));
        String string = statement = singleDatabase ? "select * from " + itemTable + " P where P.CONTAINER_NAME='" + this.jdbcDataContainer.containerConfig.containerName + "' and P.I_CLASS=2" + " and P.P_MULTIVALUED=? and NOT EXISTS( select * from " + valueTable + " V where V.PROPERTY_ID=P.ID)" : "select * from " + itemTable + " P where P.I_CLASS=2 and P.P_MULTIVALUED=? and NOT EXISTS( select * from " + valueTable + " V " + "where V.PROPERTY_ID=P.ID)";
        statement = this.jdbcDataContainer.containerConfig.dbDialect.startsWith("PGSQL") ? statement.replace("?", "'f'") : (this.jdbcDataContainer.containerConfig.dbDialect.startsWith("HSQLDB") ? statement.replace("?", "FALSE") : statement.replace("?", "0"));
        this.itemsInspectionQuery.add(new InspectionQuery(statement, new String[]{"ID", "PARENT_ID", "NAME"}, "A node that has a single valued properties with nothing declared in the VALUE table.", new PropertyRemover(this.jdbcDataContainer.getConnectionFactory(), this.jdbcDataContainer.containerConfig, this.nodeTypeManager)));
        this.itemsInspectionQuery.add(new InspectionQuery(singleDatabase ? "select * from " + itemTable + " N where N.CONTAINER_NAME='" + this.jdbcDataContainer.containerConfig.containerName + "' and N.I_CLASS=1 and NOT EXISTS (select * from " + itemTable + " P " + "where P.I_CLASS=2 and P.PARENT_ID=N.ID and P.NAME='[http://www.jcp.org/jcr/1.0]primaryType' " + "and P.CONTAINER_NAME='" + this.jdbcDataContainer.containerConfig.containerName + "')" : "select * from " + itemTable + " N where N.I_CLASS=1 and NOT EXISTS " + "(select * from " + itemTable + " P where P.I_CLASS=2 and P.PARENT_ID=N.ID " + "and P.NAME='[http://www.jcp.org/jcr/1.0]primaryType')", new String[]{"ID", "PARENT_ID", "NAME"}, "A node that doesn't have primary type property", new NodeRemover(this.jdbcDataContainer.getConnectionFactory(), this.jdbcDataContainer.containerConfig, this.nodeTypeManager)));
        this.itemsInspectionQuery.add(new InspectionQuery(singleDatabase ? "select * from " + valueTable + " V where NOT EXISTS(select * from " + itemTable + " P " + "where V.PROPERTY_ID = P.ID and P.I_CLASS=2)" : "select * from " + valueTable + " V where NOT EXISTS(select * from " + itemTable + " P " + "where V.PROPERTY_ID = P.ID and P.I_CLASS=2)", new String[]{"ID", "PROPERTY_ID"}, "All value records that has not related property record", new ValueRecordsRemover(this.jdbcDataContainer.getConnectionFactory(), this.jdbcDataContainer.containerConfig)));
        statement = this.jdbcDataContainer.containerConfig.dbDialect.startsWith("SYBASE") ? (singleDatabase ? "select V.* from " + valueTable + " V, " + itemTable + " I where V.PROPERTY_ID = I.ID and I.CONTAINER_NAME='" + this.jdbcDataContainer.containerConfig.containerName + "' AND ((STORAGE_DESC is not null and not DATA like null))" : "select * from " + valueTable + " where (STORAGE_DESC is not null and not DATA like null)") : (this.jdbcDataContainer.containerConfig.dbDialect.startsWith("ORACLE") ? (singleDatabase ? "select V.* from " + valueTable + " V, " + itemTable + " I where V.PROPERTY_ID = I.ID and I.CONTAINER_NAME='" + this.jdbcDataContainer.containerConfig.containerName + "' AND (STORAGE_DESC is not null and DATA is not null)" : "select * from " + valueTable + " where (STORAGE_DESC is not null and DATA is not null)") : (singleDatabase ? "select V.* from " + valueTable + " V, " + itemTable + " I where V.PROPERTY_ID = I.ID and I.CONTAINER_NAME='" + this.jdbcDataContainer.containerConfig.containerName + "' AND ((STORAGE_DESC is not null and DATA is not null))" : "select * from " + valueTable + " where (STORAGE_DESC is not null and DATA is not null)"));
        this.itemsInspectionQuery.add(new InspectionQuery(statement, new String[]{"ID"}, "Incorrect VALUE records. Both fields STORAGE_DESC and DATA contain not null value.", new DummyRepair()));
        this.itemsInspectionQuery.add(new InspectionQuery(singleDatabase ? "select * from " + itemTable + " I where I.ID = I.PARENT_ID and I.CONTAINER_NAME='" + this.jdbcDataContainer.containerConfig.containerName + "' and I.NAME <> '" + "__root_parent" + "'" : "select * from " + itemTable + " I where I.ID = I.PARENT_ID and I.NAME <> '" + "__root_parent" + "'", new String[]{"ID", "PARENT_ID", "NAME"}, "An item is its own parent.", new RootAsParentAssigner(this.jdbcDataContainer.getConnectionFactory(), this.jdbcDataContainer.containerConfig)));
        this.itemsInspectionQuery.add(new InspectionQuery(singleDatabase ? "select * from " + itemTable + " I where I.CONTAINER_NAME='" + this.jdbcDataContainer.containerConfig.containerName + "' and EXISTS (select * from " + itemTable + " J WHERE I.CONTAINER_NAME = J.CONTAINER_NAME and" + " I.PARENT_ID = J.PARENT_ID AND I.NAME = J.NAME and I.I_INDEX = J.I_INDEX and I.I_CLASS = J.I_CLASS" + " and I.VERSION != J.VERSION and I.I_CLASS = 2)" : "select * from " + itemTable + " I where EXISTS (select * from " + itemTable + " J" + " WHERE I.PARENT_ID = J.PARENT_ID AND I.NAME = J.NAME and I.I_INDEX = J.I_INDEX and I.I_CLASS = J.I_CLASS" + " and I.VERSION != J.VERSION and I.I_CLASS = 2)", new String[]{"ID", "PARENT_ID", "NAME", "VERSION", "I_CLASS", "I_INDEX"}, "Several versions of same item.", new EarlierVersionsRemover(this.jdbcDataContainer.getConnectionFactory(), this.jdbcDataContainer.containerConfig)));
        this.itemsInspectionQuery.add(new InspectionQuery(singleDatabase ? "select * from " + itemTable + " P, " + valueTable + " V where P.ID=V.PROPERTY_ID and P.CONTAINER_NAME='" + this.jdbcDataContainer.containerConfig.containerName + "' and P.P_TYPE=9 and NOT EXISTS (select * from " + refTable + " R where P.ID=R.PROPERTY_ID)" : "select * from " + itemTable + " P, " + valueTable + " V where P.ID=V.PROPERTY_ID and P.P_TYPE=9 and NOT EXISTS " + "(select * from " + refTable + " R where P.ID=R.PROPERTY_ID)", new String[]{"ID", "PARENT_ID", "NAME"}, "Reference properties without reference records", new PropertyRemover(this.jdbcDataContainer.getConnectionFactory(), this.jdbcDataContainer.containerConfig, this.nodeTypeManager)));
    }
}

