/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.core.itemfilters.QPathEntryFilter;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.MultiDbJDBCConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HSQLDBMultiDbJDBCConnection
extends MultiDbJDBCConnection {
    public HSQLDBMultiDbJDBCConnection(Connection dbConnection, boolean readOnly, JDBCDataContainerConfig containerConfig) throws SQLException {
        super(dbConnection, readOnly, containerConfig);
    }

    @Override
    protected void prepareQueries() throws SQLException {
        super.prepareQueries();
        this.FIND_PROPERTY_BY_NAME = "select V.DATA from " + this.JCR_ITEM + " I, " + this.JCR_VALUE + " V" + " where I.PARENT_ID=? and I.I_CLASS=2 and I.NAME=? and I.ID=V.PROPERTY_ID order by V.ORDER_NUM";
        this.FIND_NODES_BY_PARENTID = "select * from " + this.JCR_ITEM + " where PARENT_ID=? and I_CLASS=1" + " order by N_ORDER_NUM";
        this.FIND_LAST_ORDER_NUMBER_BY_PARENTID = "select count(*), max(N_ORDER_NUM) from " + this.JCR_ITEM + " where PARENT_ID=? and I_CLASS=1";
        this.FIND_NODES_COUNT_BY_PARENTID = "select count(ID) from " + this.JCR_ITEM + " where PARENT_ID=? and I_CLASS=1";
        this.FIND_PROPERTIES_BY_PARENTID = "select * from " + this.JCR_ITEM + " where PARENT_ID=? and I_CLASS=2" + " order by ID";
        this.FIND_NODES_BY_PARENTID_CQ = "select I.*, P.NAME AS PROP_NAME, V.ORDER_NUM, V.DATA from " + this.JCR_ITEM + " I, " + this.JCR_ITEM + " P, " + this.JCR_VALUE + " V" + " where I.PARENT_ID=? and I.I_CLASS=1 and (P.PARENT_ID=I.ID and P.I_CLASS=2 and" + " (P.NAME='[http://www.jcp.org/jcr/1.0]primaryType' or" + " P.NAME='[http://www.jcp.org/jcr/1.0]mixinTypes' or" + " P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner' or" + " P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions') and V.PROPERTY_ID=P.ID)" + " order by I.N_ORDER_NUM, I.ID";
        this.FIND_PROPERTIES_BY_PARENTID_CQ = "select I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_CLASS, I.I_INDEX, I.N_ORDER_NUM, I.P_TYPE, I.P_MULTIVALUED, V.ORDER_NUM, V.DATA, V.STORAGE_DESC from " + this.JCR_ITEM + " I LEFT OUTER JOIN " + this.JCR_VALUE + " V ON (V.PROPERTY_ID=I.ID)" + " where I.PARENT_ID=? and I.I_CLASS=2 order by I.NAME";
    }

    @Override
    protected QPath traverseQPath(String cpid) throws SQLException, InvalidItemStateException, IllegalNameException {
        return this.traverseQPathSQ(cpid);
    }

    @Override
    public List<NodeData> getChildNodesData(NodeData parent, List<QPathEntryFilter> itemDataFilters) throws RepositoryException, IllegalStateException {
        return this.getDirectChildNodesData(parent, itemDataFilters);
    }

    @Override
    protected ResultSet findChildNodesByParentIdentifierCQ(String parentIdentifier, List<QPathEntryFilter> pattern) throws SQLException {
        if (pattern.isEmpty()) {
            throw new SQLException("Pattern list is empty.");
        }
        if (this.findNodesByParentIdAndComplexPatternCQ == null) {
            this.findNodesByParentIdAndComplexPatternCQ = this.dbConnection.createStatement();
        }
        StringBuilder query = new StringBuilder(this.FIND_NODES_BY_PARENTID_AND_PATTERN_CQ_TEMPLATE);
        query.append(" where I.PARENT_ID='");
        query.append(parentIdentifier);
        query.append("' and I.I_CLASS=1 and ( ");
        this.appendPattern(query, pattern.get(0).getQPathEntry(), true);
        for (int i = 1; i < pattern.size(); ++i) {
            query.append(" or ");
            this.appendPattern(query, pattern.get(i).getQPathEntry(), true);
        }
        query.append(" ) and (P.PARENT_ID=I.ID and P.I_CLASS=2 and (P.NAME='[http://www.jcp.org/jcr/1.0]primaryType'");
        query.append(" or P.NAME='[http://www.jcp.org/jcr/1.0]mixinTypes'");
        query.append(" or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner'");
        query.append(" or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions')");
        query.append(" and V.PROPERTY_ID=P.ID) order by I.N_ORDER_NUM, I.ID");
        return this.findNodesByParentIdAndComplexPatternCQ.executeQuery(query.toString());
    }

    @Override
    public List<PropertyData> getChildPropertiesData(NodeData parent, List<QPathEntryFilter> itemDataFilters) throws RepositoryException, IllegalStateException {
        return this.getDirectChildPropertiesData(parent, itemDataFilters);
    }

    @Override
    protected ResultSet findChildPropertiesByParentIdentifierCQ(String parentCid, List<QPathEntryFilter> pattern) throws SQLException {
        if (pattern.isEmpty()) {
            throw new SQLException("Pattern list is empty.");
        }
        if (this.findPropertiesByParentIdAndComplexPatternCQ == null) {
            this.findPropertiesByParentIdAndComplexPatternCQ = this.dbConnection.createStatement();
        }
        StringBuilder query = new StringBuilder(this.FIND_PROPERTIES_BY_PARENTID_AND_PATTERN_CQ_TEMPLATE);
        query.append(" where I.PARENT_ID='");
        query.append(parentCid);
        query.append("' and I.I_CLASS=2 and ( ");
        this.appendPattern(query, pattern.get(0).getQPathEntry(), false);
        for (int i = 1; i < pattern.size(); ++i) {
            query.append(" or ");
            this.appendPattern(query, pattern.get(i).getQPathEntry(), false);
        }
        query.append(" ) order by I.NAME");
        return this.findPropertiesByParentIdAndComplexPatternCQ.executeQuery(query.toString());
    }
}

