/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.MultiDbJDBCConnection;

public class MySQLMultiDbJDBCConnection
extends MultiDbJDBCConnection {
    protected final Set<String> addedNodes = new HashSet<String>();
    protected final boolean innoDBEngine;
    protected static final String PATTERN_ESCAPE_STRING = "\\\\";

    public MySQLMultiDbJDBCConnection(Connection dbConnection, boolean readOnly, JDBCDataContainerConfig containerConfig) throws SQLException {
        super(dbConnection, readOnly, containerConfig);
        this.innoDBEngine = containerConfig.dbDialect.equals("MYSQL") || containerConfig.dbDialect.equals("MYSQL-UTF8");
    }

    protected void prepareQueries() throws SQLException {
        super.prepareQueries();
        this.FIND_NODE_MAIN_PROPERTIES_BY_PARENTID_CQ = this.FIND_NODE_MAIN_PROPERTIES_BY_PARENTID_CQ.replace("from " + this.JCR_ITEM + " I, " + this.JCR_VALUE + " V", "from " + this.JCR_ITEM + " I force index (" + this.JCR_IDX_ITEM_PARENT_NAME + "),  " + this.JCR_VALUE + " V force index (" + this.JCR_IDX_VALUE_PROPERTY + ")");
        this.FIND_NODES_AND_PROPERTIES = this.FIND_NODES_AND_PROPERTIES.replace("from " + this.JCR_ITEM + " I", "from " + this.JCR_ITEM + " I force index (PRIMARY)");
        this.FIND_ITEM_BY_NAME = "select * from " + this.JCR_ITEM + " where PARENT_ID=? and NAME=? and I_INDEX=? order by I_CLASS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addNodeRecord(NodeData data) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.isParentValidationNeeded(data.getParentIdentifier())) {
            ResultSet item = this.findItemByIdentifier(data.getParentIdentifier());
            try {
                if (!item.next()) {
                    throw new SQLException("Parent is not found. Behaviour of " + this.JCR_FK_ITEM_PARENT);
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    item.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e));
                }
                throw throwable;
            }
            try {
                item.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
        }
        if (!this.innoDBEngine) {
            this.addedNodes.add(data.getIdentifier());
        }
        return super.addNodeRecord(data);
    }

    public void delete(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        if (!this.innoDBEngine) {
            this.addedNodes.remove(data.getIdentifier());
        }
        super.delete(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addPropertyRecord(PropertyData data) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.isParentValidationNeeded(data.getParentIdentifier())) {
            ResultSet item = this.findItemByIdentifier(data.getParentIdentifier());
            try {
                if (!item.next()) {
                    throw new SQLException("Parent is not found. Behaviour of " + this.JCR_FK_ITEM_PARENT);
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    item.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e));
                }
                throw throwable;
            }
            try {
                item.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
        }
        return super.addPropertyRecord(data);
    }

    protected String getLikeExpressionEscape() {
        return PATTERN_ESCAPE_STRING;
    }

    public void close() throws IllegalStateException, RepositoryException {
        if (!this.innoDBEngine) {
            this.addedNodes.clear();
        }
        super.close();
    }

    protected boolean isParentValidationNeeded(String parentIdentifier) {
        return !this.innoDBEngine && parentIdentifier != null && !this.addedNodes.contains(parentIdentifier);
    }
}

