/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.jcr.nodetype.NodeType;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.action.UIActionManager;
import org.exoplatform.ecm.webui.component.admin.action.UIActionTypeForm;
import org.exoplatform.ecm.webui.core.UIPagingGrid;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.scripts.impl.ScriptServiceImpl;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="system:/groovy/ecm/webui/UIGridWithButton.gtmpl", events={@EventConfig(listeners={AddActionActionListener.class}), @EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UIActionTypeList.msg.confirm-delete")})
public class UIActionTypeList
extends UIPagingGrid {
    private static String[] ACTIONTYPE_BEAN_FIELD = new String[]{"label", "name"};
    private static String[] ACTIONTYPE_ACTION = new String[]{"Edit", "Delete"};

    public UIActionTypeList() throws Exception {
        this.getUIPageIterator().setId("ActionTypeListIterator");
        this.configure("type", ACTIONTYPE_BEAN_FIELD, ACTIONTYPE_ACTION);
    }

    public String[] getActions() {
        return new String[]{"AddAction"};
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        context.getJavascriptManager().require("SHARED/jquery", "gj").addScripts("gj(document).ready(function() { gj(\"*[rel='tooltip']\").tooltip();});");
        super.processRender(context);
    }

    public void refresh(int currentPage) throws Exception {
        ActionServiceContainer actionsServiceContainer = (ActionServiceContainer)this.getApplicationComponent(ActionServiceContainer.class);
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        ScriptServiceImpl scriptService = (ScriptServiceImpl)WCMCoreUtils.getService(ScriptServiceImpl.class);
        Collection actionList = actionsServiceContainer.getCreatedActionTypes(repository);
        ArrayList<ActionData> actions = new ArrayList<ActionData>(actionList.size());
        UIActionManager uiManager = (UIActionManager)this.getParent();
        for (NodeType action : actionList) {
            ActionData bean = new ActionData();
            String resourceName = scriptService.getResourceNameByNodeType(action);
            if (StringUtils.isEmpty((String)resourceName)) continue;
            bean.setLabel(uiManager.getScriptLabel(action));
            if (resourceName.length() == 0) {
                resourceName = action.getName();
            }
            bean.setType(action.getName());
            bean.setName(StringUtils.substringAfterLast((String)resourceName, (String)"/"));
            actions.add(bean);
        }
        Collections.sort(actions, new ActionComparator());
        LazyPageList dataPageList = new LazyPageList((ListAccess)new ListAccessImpl(ActionData.class, actions), this.getUIPageIterator().getItemsPerPage());
        this.getUIPageIterator().setTotalItems(actions.size());
        this.getUIPageIterator().setPageList((PageList)dataPageList);
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.getUIPageIterator().setCurrentPage(this.getUIPageIterator().getAvailablePage());
        } else {
            this.getUIPageIterator().setCurrentPage(currentPage);
        }
    }

    public static class ActionData {
        private String label;
        private String name;
        private String type;

        public String getName() {
            return this.name;
        }

        public void setName(String s) {
            this.name = s;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String s) {
            this.label = s;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static class AddActionActionListener
    extends EventListener<UIActionTypeList> {
        public void execute(Event<UIActionTypeList> event) throws Exception {
            UIActionManager uiActionMan = (UIActionManager)((UIActionTypeList)((Object)event.getSource())).getParent();
            UIActionTypeForm uiForm = (UIActionTypeForm)uiActionMan.findFirstComponentOfType(UIActionTypeForm.class);
            if (uiForm == null) {
                uiForm = (UIActionTypeForm)uiActionMan.createUIComponent(UIActionTypeForm.class, null, null);
            }
            uiForm.refresh();
            uiActionMan.initPopup((UIComponent)uiForm, 600);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActionMan);
        }
    }

    public static class DeleteActionListener
    extends EventListener<UIActionTypeList> {
        public void execute(Event<UIActionTypeList> event) throws Exception {
            UIActionTypeList uiList = (UIActionTypeList)((Object)event.getSource());
            String nodeTypeName = event.getRequestContext().getRequestParameter("objectId");
            UIActionManager uiActionMan = (UIActionManager)uiList.getParent();
            RepositoryService repoService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
            ExtendedNodeTypeManager ntManager = repoService.getCurrentRepository().getNodeTypeManager();
            try {
                ntManager.unregisterNodeType(nodeTypeName);
            }
            catch (Exception e) {
                UIApplication uiApp = (UIApplication)((UIActionTypeList)((Object)event.getSource())).getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIActionTypeList.msg.cannot-delete", null, 1));
                return;
            }
            uiList.refresh(uiList.getUIPageIterator().getCurrentPage());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActionMan);
        }
    }

    public static class EditActionListener
    extends EventListener<UIActionTypeList> {
        public void execute(Event<UIActionTypeList> event) throws Exception {
            UIActionTypeList uiList = (UIActionTypeList)((Object)event.getSource());
            UIActionManager uiActionMan = (UIActionManager)uiList.getParent();
            UIActionTypeForm uiForm = (UIActionTypeForm)uiActionMan.findFirstComponentOfType(UIActionTypeForm.class);
            if (uiForm == null) {
                uiForm = (UIActionTypeForm)uiActionMan.createUIComponent(UIActionTypeForm.class, null, null);
            }
            String name = event.getRequestContext().getRequestParameter("objectId");
            ExtendedNodeTypeManager ntManager = WCMCoreUtils.getRepository().getNodeTypeManager();
            String label = uiActionMan.getScriptLabel(ntManager.getNodeType(name));
            uiForm.update(name, label);
            uiActionMan.initPopup((UIComponent)uiForm, 600);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActionMan);
        }
    }

    public static class ActionComparator
    implements Comparator<ActionData> {
        @Override
        public int compare(ActionData a1, ActionData a2) throws ClassCastException {
            String label1 = a1.getLabel();
            String label2 = a2.getLabel();
            return label1.compareToIgnoreCase(label2);
        }
    }
}

