/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.namespace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.jcr.NamespaceRegistry;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.namespace.UINamespaceForm;
import org.exoplatform.ecm.webui.component.admin.namespace.UINamespaceManager;
import org.exoplatform.ecm.webui.core.UIPagingGrid;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="system:/groovy/ecm/webui/UIGridWithButton.gtmpl", events={@EventConfig(listeners={AddNamespaceActionListener.class})})
public class UINamespaceList
extends UIPagingGrid {
    private static String[] NAMESPACE_BEAN_FIELD = new String[]{"prefix", "uri"};

    public UINamespaceList() throws Exception {
        this.getUIPageIterator().setId("NamespaceListIterator");
        this.configure("prefix", NAMESPACE_BEAN_FIELD, null);
    }

    public String[] getActions() {
        return new String[]{"AddNamespace"};
    }

    public void refresh(int currentPage) throws Exception {
        NamespaceRegistry namespaceRegistry = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository().getNamespaceRegistry();
        ArrayList<NamespaceBean> nspBeans = new ArrayList<NamespaceBean>();
        String[] prefixs = namespaceRegistry.getPrefixes();
        for (int i = 0; i < prefixs.length; ++i) {
            String prefix = prefixs[i];
            if (prefix == null || prefix.trim().length() == 0) continue;
            NamespaceBean bean = new NamespaceBean(prefix, namespaceRegistry.getURI(prefix));
            nspBeans.add(bean);
        }
        Collections.sort(nspBeans, new NameSpaceComparator());
        ListAccessImpl namespaceList = new ListAccessImpl(NamespaceBean.class, nspBeans);
        LazyPageList dataPageList = new LazyPageList((ListAccess)namespaceList, this.getUIPageIterator().getItemsPerPage());
        this.getUIPageIterator().setTotalItems(nspBeans.size());
        this.getUIPageIterator().setPageList((PageList)dataPageList);
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.getUIPageIterator().setCurrentPage(this.getUIPageIterator().getAvailablePage());
        } else {
            this.getUIPageIterator().setCurrentPage(currentPage);
        }
    }

    public static class NamespaceBean {
        private String prefix;
        private String uri;

        public NamespaceBean(String prefix, String uri) {
            this.prefix = prefix;
            this.uri = uri;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getUri() {
            return this.uri;
        }
    }

    public static class AddNamespaceActionListener
    extends EventListener<UINamespaceList> {
        public void execute(Event<UINamespaceList> event) throws Exception {
            UINamespaceManager uiManager = (UINamespaceManager)((UINamespaceList)((Object)event.getSource())).getParent();
            uiManager.initPopup();
            UINamespaceForm uiForm = (UINamespaceForm)uiManager.findFirstComponentOfType(UINamespaceForm.class);
            uiForm.reset();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    public static class NameSpaceComparator
    implements Comparator<NamespaceBean> {
        @Override
        public int compare(NamespaceBean o1, NamespaceBean o2) throws ClassCastException {
            String name1 = o1.getPrefix();
            String name2 = o2.getPrefix();
            return name1.compareToIgnoreCase(name2);
        }
    }
}

