/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy.info;

import javax.jcr.Node;
import org.exoplatform.ecm.webui.component.admin.taxonomy.info.UIPermissionForm;
import org.exoplatform.ecm.webui.component.admin.taxonomy.info.UIPermissionInfo;
import org.exoplatform.ecm.webui.component.admin.taxonomy.info.UIUserContainer;
import org.exoplatform.ecm.webui.core.UIPermissionManagerBase;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.organization.account.UIUserSelector;

@ComponentConfig(template="classpath:groovy/wcm/webui/core/UIPermissionManager.gtmpl", events={@EventConfig(listeners={CloseActionListener.class})})
public class UIPermissionManager
extends UIPermissionManagerBase
implements UIPopupComponent {
    private static final Log LOG = ExoLogger.getLogger((String)UIPermissionManager.class.getName());

    public UIPermissionManager() throws Exception {
        this.addChild(UIPermissionInfo.class, null, null);
        this.addChild(UIPermissionForm.class, null, null);
    }

    public void initPopupPermission(UIComponent uiSelector) throws Exception {
        this.removeChildById("SelectUserOrGroup");
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, "SelectUserOrGroup");
        uiPopup.setShowMask(true);
        uiPopup.setWindowSize(560, 300);
        uiPopup.setRendered(true);
        uiPopup.setUIComponent(uiSelector);
        uiPopup.setShow(true);
        uiPopup.setResizable(true);
    }

    public void initUserSelector() throws Exception {
        UIPopupWindow uiPopup = (UIPopupWindow)this.getChildById("PopupUserSelector");
        if (uiPopup == null) {
            uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, "PopupUserSelector");
            uiPopup.setShowMask(true);
        }
        uiPopup.setWindowSize(790, 400);
        UIUserContainer uiUserContainer = (UIUserContainer)this.createUIComponent(UIUserContainer.class, null, null);
        uiPopup.setUIComponent((UIComponent)uiUserContainer);
        uiPopup.setShow(true);
        uiPopup.setResizable(true);
    }

    public void activate() {
        block2: {
            try {
                ((UIPermissionInfo)this.getChild(UIPermissionInfo.class)).updateGrid();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error("Unexpected error!", new Object[]{e.getMessage()});
            }
        }
    }

    public void checkPermissonInfo(Node node) throws Exception {
        if (node.isLocked()) {
            String lockToken = LockUtil.getLockToken((Node)node);
            if (lockToken != null) {
                node.getSession().addLockToken(lockToken);
            }
            if (!Utils.isLockTokenHolder((Node)node)) {
                ((UIGrid)((UIPermissionInfo)this.getChild(UIPermissionInfo.class)).getChild(UIGrid.class)).configure("usersOrGroups", UIPermissionInfo.PERMISSION_BEAN_FIELD, new String[0]);
                ((UIPermissionForm)this.getChild(UIPermissionForm.class)).setRendered(false);
            }
        } else if (!PermissionUtil.canChangePermission((Node)node)) {
            ((UIGrid)((UIPermissionInfo)this.getChild(UIPermissionInfo.class)).getChild(UIGrid.class)).configure("usersOrGroups", UIPermissionInfo.PERMISSION_BEAN_FIELD, new String[0]);
            ((UIPermissionForm)this.getChild(UIPermissionForm.class)).setRendered(false);
        }
    }

    public void deActivate() {
    }

    public static class CloseActionListener
    extends EventListener<UIPermissionManager> {
        public void execute(Event<UIPermissionManager> event) throws Exception {
            UIPopupWindow popupAction = (UIPopupWindow)((UIPermissionManager)((Object)event.getSource())).getAncestorOfType(UIPopupWindow.class);
            popupAction.setRendered(false);
            popupAction.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popupAction);
        }
    }

    public static class AddUserActionListener
    extends EventListener<UIUserSelector> {
        public void execute(Event<UIUserSelector> event) throws Exception {
            UIUserSelector uiForm = (UIUserSelector)event.getSource();
            UIPermissionManager uiParent = (UIPermissionManager)uiForm.getAncestorOfType(UIPermissionManager.class);
            UIPermissionForm uiPermissionForm = (UIPermissionForm)uiParent.getChild(UIPermissionForm.class);
            uiPermissionForm.doSelect("userOrGroup", uiForm.getSelectedUsers());
            UIPopupWindow uiPopup = (UIPopupWindow)uiParent.getChild(UIPopupWindow.class);
            uiPopup.setUIComponent(null);
            uiPopup.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiParent);
        }
    }
}

