/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.control.action;

import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.control.UIActionBar;
import org.exoplatform.ecm.webui.component.explorer.control.filter.CanRemoveNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.CanSetPropertyFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.HasPublicationLifecycleFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsDocumentFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotIgnoreVersionNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotLockedFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotRootNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIActionBarActionListener;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIActivePublication;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIPublicationManager;
import org.exoplatform.services.ecm.publication.PublicationPresentationService;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.ecm.publication.plugins.webui.UIPublicationLogList;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(events={@EventConfig(listeners={ManagePublicationsActionListener.class})})
public class ManagePublicationsActionComponent
extends UIComponent {
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new HasPublicationLifecycleFilter(), new IsDocumentFilter("UIActionBar.msg.manage-publication.not-supported-nodetype"), new IsNotRootNodeFilter("UIActionBar.msg.cannot-enable-publication-rootnode"), new CanSetPropertyFilter("UIActionBar.msg.access-denied"), new CanRemoveNodeFilter(), new IsNotLockedFilter(), new IsNotIgnoreVersionNodeFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public static class ManagePublicationsActionListener
    extends UIActionBarActionListener<ManagePublicationsActionComponent> {
        public void processEvent(Event<ManagePublicationsActionComponent> event) throws Exception {
            UIActionBar uiActionBar = (UIActionBar)((ManagePublicationsActionComponent)((Object)event.getSource())).getAncestorOfType(UIActionBar.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiActionBar.getAncestorOfType(UIJCRExplorer.class);
            UIPopupContainer UIPopupContainer2 = (UIPopupContainer)uiExplorer.getChild(UIPopupContainer.class);
            Node currentNode = uiExplorer.getCurrentNode();
            uiExplorer.setIsHidePopup(false);
            PublicationService publicationService = (PublicationService)uiActionBar.getApplicationComponent(PublicationService.class);
            PublicationPresentationService publicationPresentationService = (PublicationPresentationService)uiActionBar.getApplicationComponent(PublicationPresentationService.class);
            if (!publicationService.isNodeEnrolledInLifecycle(currentNode)) {
                UIActivePublication activePublication = (UIActivePublication)uiActionBar.createUIComponent(UIActivePublication.class, null, null);
                if (publicationService.getPublicationPlugins().size() == 1) {
                    activePublication.setRendered(false);
                    uiExplorer.addChild((UIComponent)activePublication);
                    String lifecycleName = (String)publicationService.getPublicationPlugins().keySet().iterator().next();
                    activePublication.enrolNodeInLifecycle(currentNode, lifecycleName, event.getRequestContext());
                    return;
                }
                activePublication.setRendered(true);
                activePublication.refresh(activePublication.getUIPageIterator().getCurrentPage());
                UIPopupContainer2.activate((UIComponent)activePublication, 600, 300);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)UIPopupContainer2);
                return;
            }
            UIContainer cont = (UIContainer)uiActionBar.createUIComponent(UIContainer.class, null, null);
            UIForm uiForm = publicationPresentationService.getStateUI(currentNode, (UIComponent)cont);
            if (uiForm instanceof UIPopupComponent) {
                UIPopupContainer2.activate((UIComponent)uiForm, 700, 500);
            } else {
                UIPublicationManager uiPublicationManager = (UIPublicationManager)uiExplorer.createUIComponent(UIPublicationManager.class, null, null);
                uiPublicationManager.addChild((UIComponent)uiForm);
                ((UIPublicationLogList)uiPublicationManager.addChild(UIPublicationLogList.class, null, null)).setRendered(false);
                UIPublicationLogList uiPublicationLogList = (UIPublicationLogList)uiPublicationManager.getChild(UIPublicationLogList.class);
                UIPopupContainer2.activate((UIComponent)uiPublicationManager, 700, 500);
                uiPublicationLogList.setNode(currentNode);
                uiPublicationLogList.updateGrid();
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)UIPopupContainer2);
        }
    }
}

