/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.mow.core.api.wiki;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.chromattic.api.annotations.Destroy;
import org.chromattic.api.annotations.ManyToOne;
import org.chromattic.api.annotations.Name;
import org.chromattic.api.annotations.Path;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Property;
import org.chromattic.api.annotations.WorkspaceName;
import org.chromattic.ext.ntdef.NTFile;
import org.chromattic.ext.ntdef.Resource;
import org.exoplatform.wiki.mow.api.Attachment;
import org.exoplatform.wiki.mow.api.Permission;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.mow.core.api.wiki.PermissionImpl;
import org.exoplatform.wiki.service.PermissionType;
import org.exoplatform.wiki.utils.Utils;

@PrimaryType(name="wiki:attachment")
public abstract class AttachmentImpl
extends NTFile
implements Attachment,
Comparable<AttachmentImpl> {
    private Permission permission = new PermissionImpl();

    @Name
    public abstract String getName();

    public abstract void setName(String var1);

    @Path
    public abstract String getPath();

    public String getJCRContentPath() {
        return this.getPath() + "/jcr:content";
    }

    @WorkspaceName
    public abstract String getWorkspace();

    @Override
    @Property(name="title")
    public abstract String getTitle();

    @Override
    public abstract void setTitle(String var1);

    @Property(name="fileType")
    public abstract String getFileType();

    public abstract void setFileType(String var1);

    @Override
    @Property(name="creator")
    public abstract String getCreator();

    public abstract void setCreator(String var1);

    @Override
    public Calendar getCreatedDate() {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(this.getCreated());
        return calendar;
    }

    @Override
    public long getWeightInBytes() {
        return this.getContentResource().getData().length;
    }

    @Override
    public Calendar getUpdatedDate() {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(this.getLastModified());
        return calendar;
    }

    @Override
    public String getDownloadURL() {
        StringBuilder sb = new StringBuilder();
        String mimeType = this.getContentResource().getMimeType();
        PageImpl page = this.getParentPage();
        Wiki wiki = page.getWiki();
        if (mimeType != null && mimeType.startsWith("image/") && wiki != null) {
            sb.append(Utils.getDefaultRestBaseURI()).append("/wiki/images/").append(wiki.getType()).append("/").append("space").append("/").append(Utils.validateWikiOwner(wiki.getType(), wiki.getOwner())).append("/").append("page").append("/").append(page.getName()).append("/").append(this.getName());
        } else {
            sb.append(Utils.getCurrentRepositoryWebDavUri());
            sb.append(this.getWorkspace());
            String path = this.getPath();
            try {
                String parentPath = path.substring(0, path.lastIndexOf("/"));
                sb.append(parentPath + "/" + URLEncoder.encode(this.getName(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                sb.append(path);
            }
        }
        return sb.toString();
    }

    public String getFullTitle() {
        String fullTitle = this.getFileType() == null ? this.getTitle() : this.getTitle().concat(this.getFileType());
        return fullTitle != null ? fullTitle : this.getName();
    }

    @ManyToOne
    public abstract PageImpl getParentPage();

    @Destroy
    public abstract void remove();

    @Override
    public String getText() {
        Resource textContent = this.getContentResource();
        if (textContent == null) {
            this.setText("");
            textContent = this.getContentResource();
        }
        try {
            return new String(textContent.getData(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(textContent.getData());
        }
    }

    @Override
    public void setText(String text) {
        text = text != null ? text : "";
        Resource textContent = Resource.createPlainText((String)text);
        this.setContentResource(textContent);
    }

    @Override
    public boolean hasPermission(PermissionType permissionType) throws Exception {
        if (this.permission.getMOWService() == null) {
            this.permission.setMOWService(this.getParentPage().getMOWService());
        }
        return this.permission.hasPermission(permissionType, this.getPath());
    }

    @Override
    public HashMap<String, String[]> getPermission() throws Exception {
        if (this.permission.getMOWService() == null) {
            this.permission.setMOWService(this.getParentPage().getMOWService());
        }
        return this.permission.getPermission(this.getPath());
    }

    @Override
    public void setPermission(HashMap<String, String[]> permissions) throws Exception {
        if (this.permission.getMOWService() == null) {
            this.permission.setMOWService(this.getParentPage().getMOWService());
        }
        this.permission.setPermission(permissions, this.getPath());
    }

    @Override
    public int compareTo(AttachmentImpl o) {
        return this.getName().toLowerCase().compareTo(o.getName().toLowerCase());
    }
}

