/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.mow.core.api.wiki;

import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Property;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.wiki.chromattic.ext.ntdef.NTVersion;
import org.exoplatform.wiki.mow.api.DraftPage;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.core.api.wiki.AttachmentImpl;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.diff.DiffResult;
import org.exoplatform.wiki.service.diff.DiffService;
import org.exoplatform.wiki.utils.Utils;

@PrimaryType(name="exo:draftPage")
public abstract class DraftPageImpl
extends PageImpl
implements DraftPage {
    @Override
    @Property(name="exo:targetPage")
    public abstract String getTargetPage();

    @Override
    public abstract void setTargetPage(String var1);

    @Override
    @Property(name="exo:targetRevision")
    public abstract String getTargetRevision();

    @Override
    public abstract void setTargetRevision(String var1);

    @Override
    @Property(name="exo:isNewPage")
    public abstract boolean isNewPage();

    @Override
    public abstract void setNewPage(boolean var1);

    @Override
    public boolean isOutDate() throws Exception {
        PageImpl targetPage;
        String targetRevision = this.getTargetRevision();
        if (targetRevision == null) {
            return false;
        }
        if (targetRevision.equals("rootVersion")) {
            targetRevision = "1";
        }
        if ((targetPage = (PageImpl)this.getTargetWikiPage()) == null) {
            return true;
        }
        String lastestRevision = Utils.getLastRevisionOfPage(targetPage).getName();
        if (lastestRevision == null) {
            return true;
        }
        if (lastestRevision.equals("rootVersion")) {
            lastestRevision = "1";
        }
        return lastestRevision.compareTo(targetRevision) > 0;
    }

    private Page getTargetWikiPage() throws Exception {
        WikiService wservice = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
        return wservice.getWikiPageByUUID(this.getTargetPage());
    }

    @Override
    public DiffResult getChanges() throws Exception {
        NTVersion lastestRevision;
        PageImpl targetPage;
        String targetContent = "";
        if (!this.isNewPage() && (targetPage = (PageImpl)this.getTargetWikiPage()) != null && (targetContent = ((AttachmentImpl)(lastestRevision = Utils.getLastRevisionOfPage(targetPage)).getNTFrozenNode().getChildren().get("content")).getText()) == null) {
            targetContent = "";
        }
        DiffService diffService = (DiffService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(DiffService.class);
        return diffService.getDifferencesAsHTML(targetContent, this.getContent().getText(), true);
    }
}

