/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.macro;

import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.rendering.RenderingService;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.syntax.Syntax;

public class ExcerptUtils {
    public static String getExcerpts(WikiPageParams params) throws Exception {
        WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
        PageImpl page = (PageImpl)wikiService.getPageById(params.getType(), params.getOwner(), params.getPageId());
        return ExcerptUtils.getExcerpts(page.getContent().getText(), page.getSyntax());
    }

    private static String getExcerpts(String markup, String sourceSyntax) throws Exception {
        RenderingService renderingService = (RenderingService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RenderingService.class);
        StringBuilder sb = new StringBuilder();
        if (markup != null) {
            XDOM xdom = renderingService.parse(markup, sourceSyntax);
            List mBlocks = xdom.getChildrenByType(MacroBlock.class, true);
            for (MacroBlock block : mBlocks) {
                if (!block.getId().equals("excerpt")) continue;
                sb.append("<span class=\"Excerpt\">");
                sb.append(renderingService.render(" (" + block.getContent() + ")", sourceSyntax, Syntax.XHTML_1_0.toIdString(), false));
                sb.append("</span>");
            }
        }
        return sb.toString();
    }
}

