/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.ckeditor;

import java.io.Writer;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.RequireJS;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.ckeditor.CKConfigListener;
import org.exoplatform.webui.ckeditor.CKEditorConfig;
import org.exoplatform.webui.ckeditor.TagHelper;
import org.exoplatform.webui.form.UIFormInputBase;

public class UIFormCKEditorInput
extends UIFormInputBase<String> {
    private CKEditorConfig editorConfig;

    public UIFormCKEditorInput(String name, String bindingField, String value) {
        super(name, bindingField, String.class);
        this.value_ = value;
    }

    public CKEditorConfig getEditorConfig() {
        return this.editorConfig;
    }

    public void setEditorConfig(CKEditorConfig editorConfig) {
        this.editorConfig = editorConfig;
    }

    public void decode(Object input, WebuiRequestContext context) {
        this.value_ = (String)input;
        if (this.value_ != null && ((String)this.value_).length() == 0) {
            this.value_ = null;
        }
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        Writer writer = context.getWriter();
        JavascriptManager jsManager = context.getJavascriptManager();
        RequireJS requirejs = jsManager.require("SHARED/commons.editor", "editor");
        String ckBasePath = CKConfigListener.CK_CONTEXT_PATH;
        requirejs.addScripts("window.CKEDITOR_BASEPATH='" + ckBasePath + "/ckeditor/';");
        writer.write("<textarea id='" + this.name + "' name='" + this.name + "'>" + (this.value_ != null ? (String)this.value_ : "") + "</textarea>");
        if (this.editorConfig != null && !this.editorConfig.isEmpty()) {
            String config = TagHelper.jsEncode(this.editorConfig);
            requirejs.addScripts("editor.EXOCKEDITOR.makeCKEditor('" + this.name + "', " + config + ");");
        } else {
            requirejs.addScripts("editor.EXOCKEDITOR.makeCKEditor('" + this.name + "');");
        }
    }
}

