/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.common.webui.cssfile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CssClassIconFile {
    public static final String DEFAULT_TYPE = "default";
    public static final String DEFAULT_CSS = "FileDefault";
    private String type;
    private String cssClass;
    private String groupFileTypes;
    private List<String> listGroupFileTypes = null;
    private static CssClassIconFile defaultType;

    public static synchronized CssClassIconFile getDefault() {
        if (defaultType == null) {
            defaultType = new CssClassIconFile();
            defaultType.setType(DEFAULT_TYPE);
            defaultType.setCssClass(DEFAULT_CSS);
        }
        return defaultType;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public String getGroupFileTypes() {
        return this.groupFileTypes;
    }

    public void setGroupFileTypes(String groupFileTypes) {
        this.groupFileTypes = groupFileTypes;
    }

    public List<String> getListGroupFileTypes() {
        return this.listGroupFileTypes;
    }

    public void setListGroupFileTypes() {
        if (this.groupFileTypes == null) {
            this.groupFileTypes = "";
        }
        this.groupFileTypes = this.groupFileTypes.replaceAll("\\s", "");
        this.listGroupFileTypes = new ArrayList<String>(Arrays.asList(this.groupFileTypes.split(",")));
    }

    public boolean containInGroupFileTypes(String fileType) {
        if (fileType == null || fileType.isEmpty()) {
            return false;
        }
        if (this.listGroupFileTypes == null) {
            this.setListGroupFileTypes();
        }
        for (String cssClass : this.listGroupFileTypes) {
            if (cssClass.indexOf(this.getFileType(fileType)) < 0) continue;
            return true;
        }
        return false;
    }

    private String getFileType(String fileType) {
        fileType = fileType.replaceAll("\\.", "");
        return fileType.substring(fileType.indexOf("/") + 1).toLowerCase();
    }

    public boolean equals(Object object) {
        if (object instanceof CssClassIconFile) {
            CssClassIconFile binCSSFile = (CssClassIconFile)object;
            return binCSSFile.getType().equals(this.type) || binCSSFile.getCssClass().equals(this.cssClass);
        }
        return false;
    }

    public String toString() {
        return "[type=" + this.type + ", cssClass=" + this.cssClass + ", groupFileTypes=" + this.groupFileTypes + "]";
    }
}

