/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;

public class FieldCleanupPass
implements HotSwapCompilerPass {
    private final AbstractCompiler compiler;

    public FieldCleanupPass(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        String srcName = originalRoot.getSourceFileName();
        QualifiedNameSearchTraversal cb = new QualifiedNameSearchTraversal(this.compiler.getTypeRegistry(), srcName);
        new NodeTraversal(this.compiler, cb).traverse(originalRoot);
    }

    @Override
    public void process(Node externs, Node root) {
    }

    static class QualifiedNameSearchTraversal
    extends NodeTraversal.AbstractShallowCallback {
        private final JSTypeRegistry typeRegistry;
        private final String srcName;

        public QualifiedNameSearchTraversal(JSTypeRegistry typeRegistry, String srcName) {
            this.typeRegistry = typeRegistry;
            this.srcName = srcName;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node p) {
            if (n.isGetProp() && !p.isGetProp()) {
                String propName = this.getFieldName(n);
                JSType type = n.getFirstChild().getJSType();
                if (type == null || type.toObjectType() == null) {
                    return;
                }
                this.removeProperty(type.toObjectType(), propName);
            }
            if (n.getJSDocInfo() != null) {
                n.getJSDocInfo().setAssociatedNode(null);
            }
        }

        private void removeProperty(ObjectType type, String propName) {
            Node pNode = type.getPropertyNode(propName);
            if (pNode != null && this.srcName.equals(pNode.getSourceFileName())) {
                this.typeRegistry.unregisterPropertyOnType(propName, type);
                type.removeProperty(propName);
            }
        }

        private String getFieldName(Node n) {
            return n.getLastChild().getString();
        }
    }
}

