/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.management.operations.navigation;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.portal.config.model.I18NString;
import org.exoplatform.portal.config.model.LocalizedString;
import org.exoplatform.portal.config.model.NavigationFragment;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.mop.Described;
import org.exoplatform.portal.mop.description.DescriptionService;
import org.exoplatform.portal.mop.management.operations.navigation.NavigationKey;
import org.exoplatform.portal.mop.navigation.GenericScope;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;

public class NavigationUtils {
    private NavigationUtils() {
    }

    public static PageNavigation loadPageNavigation(NavigationKey key, NavigationService navigationService, DescriptionService descriptionService) {
        NavigationContext navigation = navigationService.loadNavigation(key.getSiteKey());
        if (navigation == null) {
            return null;
        }
        NodeContext<NodeContext<?>> node = NavigationUtils.loadNode(navigationService, navigation, key.getNavUri());
        if (node == null) {
            return null;
        }
        if (key.getNavUri() != null) {
            return NavigationUtils.createFragmentedPageNavigation(descriptionService, navigation, node);
        }
        return NavigationUtils.createPageNavigation(descriptionService, navigation, node);
    }

    public static NodeContext<NodeContext<?>> loadNode(NavigationService navigationService, NavigationContext navigation, String navUri) {
        if (navigation == null) {
            return null;
        }
        if (navUri != null) {
            String name;
            String[] path = NavigationUtils.trim(navUri.split("/"));
            NodeContext<NodeContext<?>> node = navigationService.loadNode(NodeModel.SELF_MODEL, navigation, GenericScope.branchShape(path, Scope.ALL), null);
            String[] arr$ = path;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (node = node.get(name = arr$[i$])) != null; ++i$) {
            }
            return node;
        }
        return navigationService.loadNode(NodeModel.SELF_MODEL, navigation, Scope.ALL, null);
    }

    public static PageNavigation createPageNavigation(DescriptionService service, NavigationContext navigation, NodeContext<NodeContext<?>> node) {
        PageNavigation pageNavigation = new PageNavigation();
        pageNavigation.setPriority(navigation.getState().getPriority());
        pageNavigation.setOwnerType(navigation.getKey().getTypeName());
        pageNavigation.setOwnerId(navigation.getKey().getName());
        ArrayList<PageNode> children = new ArrayList<PageNode>(node.getNodeCount());
        Iterator<NodeContext<?>> i$ = node.getNodes().iterator();
        while (i$.hasNext()) {
            NodeContext<NodeContext<?>> child;
            NodeContext<NodeContext<?>> childNode = child = i$.next();
            children.add(NavigationUtils.createPageNode(service, childNode));
        }
        NavigationFragment fragment = new NavigationFragment();
        fragment.setNodes(children);
        pageNavigation.addFragment(fragment);
        return pageNavigation;
    }

    private static PageNavigation createFragmentedPageNavigation(DescriptionService service, NavigationContext navigation, NodeContext<NodeContext<?>> node) {
        PageNavigation pageNavigation = new PageNavigation();
        pageNavigation.setPriority(navigation.getState().getPriority());
        pageNavigation.setOwnerType(navigation.getKey().getTypeName());
        pageNavigation.setOwnerId(navigation.getKey().getName());
        ArrayList<PageNode> children = new ArrayList<PageNode>(1);
        children.add(NavigationUtils.createPageNode(service, node));
        NavigationFragment fragment = new NavigationFragment();
        StringBuilder parentUri = new StringBuilder("");
        NavigationUtils.getPath((NodeContext)node.getParent(), parentUri);
        fragment.setParentURI(parentUri.toString());
        fragment.setNodes(children);
        pageNavigation.addFragment(fragment);
        return pageNavigation;
    }

    private static void getPath(NodeContext<NodeContext<?>> node, StringBuilder parentUri) {
        if (node == null) {
            return;
        }
        if (node.getParent() == null) {
            return;
        }
        parentUri.insert(0, node.getName()).insert(0, "/");
        NavigationUtils.getPath((NodeContext)node.getParent(), parentUri);
    }

    private static PageNode createPageNode(DescriptionService service, NodeContext<NodeContext<?>> node) {
        long endPublicationTime;
        PageNode pageNode = new PageNode();
        pageNode.setName(node.getName());
        if (node.getState().getLabel() == null) {
            Map<Locale, Described.State> descriptions = service.getDescriptions(node.getId());
            if (descriptions != null && !descriptions.isEmpty()) {
                I18NString labels = new I18NString();
                for (Map.Entry<Locale, Described.State> entry : descriptions.entrySet()) {
                    labels.add(new LocalizedString(entry.getValue().getName(), entry.getKey()));
                }
                pageNode.setLabels(labels);
            }
        } else {
            pageNode.setLabel(node.getState().getLabel());
        }
        pageNode.setIcon(node.getState().getIcon());
        long startPublicationTime = node.getState().getStartPublicationTime();
        if (startPublicationTime != -1L) {
            pageNode.setStartPublicationDate(new Date(startPublicationTime));
        }
        if ((endPublicationTime = node.getState().getEndPublicationTime()) != -1L) {
            pageNode.setEndPublicationDate(new Date(endPublicationTime));
        }
        pageNode.setVisibility(node.getState().getVisibility());
        pageNode.setPageReference(node.getState().getPageRef() != null ? node.getState().getPageRef().format() : null);
        if (node.getNodes() != null) {
            ArrayList<PageNode> children = new ArrayList<PageNode>(node.getNodeCount());
            Iterator<NodeContext<?>> i$ = node.getNodes().iterator();
            while (i$.hasNext()) {
                NodeContext<NodeContext<?>> child;
                NodeContext<NodeContext<?>> childNode = child = i$.next();
                children.add(NavigationUtils.createPageNode(service, childNode));
            }
            pageNode.setChildren(children);
        } else {
            pageNode.setChildren(new ArrayList<PageNode>(0));
        }
        return pageNode;
    }

    private static String[] trim(String[] array) {
        ArrayList<String> trimmed = new ArrayList<String>(array.length);
        for (String s : array) {
            if (s == null || "".equals(s)) continue;
            trimmed.add(s);
        }
        return trimmed.toArray(new String[trimmed.size()]);
    }
}

