/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.social.core.chromattic.entity.ActivityProfileEntity;
import org.exoplatform.social.core.identity.model.Identity;

public class Profile {
    public static final String GENDER = "gender";
    public static final String USERNAME = "username";
    public static final String FIRST_NAME = "firstName";
    public static final String LAST_NAME = "lastName";
    public static final String FULL_NAME = "fullName";
    public static final String EMAIL = "email";
    public static final String DELETED = "deleted";
    public static final String AVATAR = "avatar";
    @Deprecated
    public static final String AVATAR_URL = "avatarUrl";
    public static final String EXPERIENCES = "experiences";
    public static final String EXPERIENCES_COMPANY = "company";
    public static final String EXPERIENCES_POSITION = "position";
    public static final String EXPERIENCES_SKILLS = "skills";
    public static final String EXPERIENCES_START_DATE = "startDate";
    public static final String EXPERIENCES_END_DATE = "endDate";
    public static final String EXPERIENCES_IS_CURRENT = "isCurrent";
    public static final String EXPERIENCES_DESCRIPTION = "description";
    public static final String POSITION = "position";
    @Deprecated
    public static final String URL = "Url";
    public static final String CONTACT_PHONES = "phones";
    public static final String CONTACT_IMS = "ims";
    public static final String CONTACT_URLS = "urls";
    public static final String URL_POSTFIX = "Url";
    public static final String RESIZED_SUBFIX = "RESIZED_";
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private static final Map<UpdateType, String[]> updateTypes = new HashMap<UpdateType, String[]>();
    private final Identity identity;
    private String id;
    private long lastLoaded;
    private boolean hasChanged;
    private UpdateType updateType;
    private String url;
    private String avatarUrl;
    private AttachedActivityType attachedActivityType;
    private long createdTime;

    public Profile(Identity identity) {
        this.identity = identity;
    }

    public final Identity getIdentity() {
        return this.identity;
    }

    public final String getId() {
        return this.id;
    }

    public final void setId(String id) {
        this.id = id;
    }

    public final long getLastLoaded() {
        return this.lastLoaded;
    }

    public final void setLastLoaded(long lastLoaded) {
        this.lastLoaded = lastLoaded;
    }

    public final boolean hasChanged() {
        return this.hasChanged;
    }

    public final void clearHasChanged() {
        this.setHasChanged(false);
    }

    public UpdateType getUpdateType() {
        return this.updateType;
    }

    public AttachedActivityType getAttachedActivityType() {
        return this.attachedActivityType;
    }

    public void setAttachedActivityType(AttachedActivityType attachedActivityType) {
        this.attachedActivityType = attachedActivityType;
    }

    protected void setUpdateType(String updateType) {
        block0: for (UpdateType key : updateTypes.keySet()) {
            String[] updateTypeValues;
            for (String value : updateTypeValues = updateTypes.get((Object)key)) {
                if (!value.equals(updateType)) continue;
                this.updateType = key;
                continue block0;
            }
        }
    }

    private void setHasChanged(boolean hasChanged) {
        this.hasChanged = hasChanged;
    }

    public final Object getProperty(String name) {
        if ("Url".equals(name)) {
            return this.url;
        }
        if (AVATAR_URL.equals(name)) {
            return this.avatarUrl;
        }
        return this.properties.get(name);
    }

    public final void setProperty(String name, Object value) {
        if ("Url".equals(name)) {
            this.url = value.toString();
            return;
        }
        if (AVATAR_URL.equals(name)) {
            this.avatarUrl = value.toString();
            return;
        }
        this.properties.put(name, value);
        this.setHasChanged(true);
        this.setUpdateType(name);
    }

    public final boolean contains(String name) {
        return this.properties.containsKey(name);
    }

    public final Map<String, Object> getProperties() {
        return this.properties;
    }

    public final void removeProperty(String name) {
        this.properties.remove(name);
        this.setHasChanged(true);
    }

    public final Object getPropertyValue(String name) {
        return this.getProperty(name);
    }

    public final String getFullName() {
        String first = (String)this.getProperty(FIRST_NAME);
        String last = (String)this.getProperty(LAST_NAME);
        String fullName = this.getProperty(FULL_NAME) != null ? (String)this.getProperty(FULL_NAME) : "";
        String all = first != null ? first : "";
        all = all + (last != null ? " " + last : "");
        return all.length() > 0 ? all : fullName;
    }

    public final String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public final String getEmail() {
        return (String)this.getProperty(EMAIL);
    }

    public final void addOrModifyProperties(Map<String, Object> props) {
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            String key = entry.getKey();
            if (key.contains(":")) continue;
            this.setProperty(key, entry.getValue());
        }
        this.setHasChanged(true);
    }

    @Deprecated
    public final String getAvatarImageSource() {
        return this.getAvatarUrl();
    }

    public final String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public final String getPosition() {
        return (String)this.getProperty("position");
    }

    public final String getGender() {
        return (String)this.getProperty(GENDER);
    }

    public final List<Map<String, String>> getPhones() {
        return (List)this.getProperty(CONTACT_PHONES);
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Long createdTime) {
        this.createdTime = createdTime != null ? createdTime : System.currentTimeMillis();
    }

    public final String toString() {
        return "[uuid : " + this.id + " identity : " + this.identity.getId() + " properties: " + this.properties;
    }

    static {
        updateTypes.put(UpdateType.POSITION, new String[]{"position"});
        updateTypes.put(UpdateType.BASIC_INFOR, new String[]{FIRST_NAME, LAST_NAME, EMAIL});
        updateTypes.put(UpdateType.CONTACT, new String[]{GENDER, CONTACT_PHONES, CONTACT_IMS, CONTACT_URLS});
        updateTypes.put(UpdateType.EXPERIENCES, new String[]{EXPERIENCES});
        updateTypes.put(UpdateType.AVATAR, new String[]{AVATAR});
    }

    public static enum AttachedActivityType {
        USER("userProfileActivityId"),
        SPACE("spaceProfileActivityId"),
        RELATION("relationActivityId"),
        RELATIONSHIP("relationShipActivityId");

        private String type;

        private AttachedActivityType(String type) {
            this.type = type;
        }

        public String value() {
            return this.type;
        }

        public void setActivityId(ActivityProfileEntity entity, String activityId) {
            switch (this) {
                case USER: {
                    entity.setUserProfileActivityId(activityId);
                    break;
                }
                case SPACE: {
                    entity.setSpaceProfileActivityId(activityId);
                    break;
                }
                case RELATION: {
                    entity.setRelationActivityId(activityId);
                    break;
                }
                case RELATIONSHIP: {
                    entity.setRelationShipActivityId(activityId);
                    break;
                }
            }
        }

        public String getActivityId(ActivityProfileEntity entity) {
            switch (this) {
                case USER: {
                    return entity.getUserProfileActivityId();
                }
                case SPACE: {
                    return entity.getSpaceProfileActivityId();
                }
                case RELATION: {
                    return entity.getRelationActivityId();
                }
                case RELATIONSHIP: {
                    return entity.getRelationShipActivityId();
                }
            }
            return null;
        }
    }

    public static enum UpdateType {
        POSITION,
        BASIC_INFOR,
        CONTACT,
        EXPERIENCES,
        AVATAR;

    }
}

