/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.social.common.ResourceBundleUtil;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.processor.ActivityResourceBundlePlugin;
import org.exoplatform.social.core.processor.I18NActivityUtils;

public final class I18NActivityProcessor {
    private static final Log LOG = ExoLogger.getLogger(I18NActivityProcessor.class);
    private Map<String, ActivityResourceBundlePlugin> resourceBundlePluginMap;
    private ResourceBundleService resourceBundleService;

    public void addActivityResourceBundlePlugin(ActivityResourceBundlePlugin activityResourceBundlePlugin) {
        activityResourceBundlePlugin.setActivityType(activityResourceBundlePlugin.getName());
        if (!activityResourceBundlePlugin.isValid()) {
            LOG.warn((Object)"Failed to register the plugin: not valid");
            return;
        }
        if (this.resourceBundlePluginMap == null) {
            this.resourceBundlePluginMap = new HashMap<String, ActivityResourceBundlePlugin>();
        }
        this.resourceBundlePluginMap.put(activityResourceBundlePlugin.getActivityType(), activityResourceBundlePlugin);
    }

    public void removeActivityResourceBundlePlugin(ActivityResourceBundlePlugin activityResourceBundlePlugin) {
        if (!activityResourceBundlePlugin.isValid()) {
            LOG.warn((Object)"Failed to remove the plugin: not valid");
        }
        if (this.resourceBundlePluginMap == null) {
            LOG.info((Object)"resourceBundlePluginMap is null.");
            return;
        }
        this.resourceBundlePluginMap.remove(activityResourceBundlePlugin.getActivityType());
    }

    public ExoSocialActivity process(ExoSocialActivity i18nActivity, Locale selectedLocale) {
        if (i18nActivity.getTitleId() != null && this.activityTypeRegistered(i18nActivity)) {
            ResourceBundle resourceBundle = this.getResourceBundle(i18nActivity, selectedLocale);
            if (resourceBundle == null) {
                LOG.warn((Object)("no resource bundle key found registered for: " + this.getResourceBundleKeyFile(i18nActivity)));
                return i18nActivity;
            }
            if (this.getMessageBundleKey(i18nActivity) == null) {
                LOG.warn((Object)("Failed to find registered message bundle key for titleId: " + i18nActivity.getTitleId()));
                return i18nActivity;
            }
            String newTitle = this.appRes(resourceBundle, this.getMessageBundleKey(i18nActivity), i18nActivity.getTemplateParams());
            if (newTitle != null) {
                i18nActivity.setTitle(newTitle);
            }
        }
        return i18nActivity;
    }

    public ExoSocialActivity processKeys(ExoSocialActivity i18nActivity, Locale selectedLocale) {
        if (i18nActivity.getTitleId() != null && this.activityTypeRegistered(i18nActivity)) {
            ResourceBundle resourceBundle = this.getResourceBundle(i18nActivity, selectedLocale);
            if (resourceBundle == null) {
                LOG.warn((Object)("no resource bundle key found registered for: " + this.getResourceBundleKeyFile(i18nActivity)));
                return i18nActivity;
            }
            if (!this.getMessageBundleKeys(i18nActivity)) {
                LOG.warn((Object)("Failed to find registered message bundle key for titleId: " + i18nActivity.getTitleId()));
                return i18nActivity;
            }
            this.transformKeys(i18nActivity, resourceBundle);
        }
        return i18nActivity;
    }

    public void setResourceBundleService(ResourceBundleService resourceBundleService) {
        this.resourceBundleService = resourceBundleService;
    }

    private ExoSocialActivity transformKeys(ExoSocialActivity i18nActivity, ResourceBundle resourceBundle) {
        String[] resourceKeys = I18NActivityUtils.getResourceKeys(i18nActivity);
        String[] resourceParamValues = I18NActivityUtils.getResourceValues(i18nActivity);
        String type = i18nActivity.getType();
        int count = 0;
        StringBuilder sb = new StringBuilder();
        String[] valuesOfParam = null;
        String key = null;
        for (int i = 0; i < resourceKeys.length; ++i) {
            key = resourceKeys[i];
            valuesOfParam = I18NActivityUtils.getParamValues(resourceParamValues[i]);
            String title = this.appRes(resourceBundle, this.getMessageBundleKey(type, key), valuesOfParam);
            sb.append(title);
            if (++count >= resourceKeys.length) continue;
            sb.append("<br/>");
        }
        String newTitle = sb.toString();
        if (newTitle.length() > 0) {
            i18nActivity.setTitle(newTitle);
        }
        return i18nActivity;
    }

    private boolean activityTypeRegistered(ExoSocialActivity i18nActivity) {
        if (this.resourceBundlePluginMap == null) {
            return false;
        }
        return this.resourceBundlePluginMap.containsKey(i18nActivity.getType());
    }

    private String getMessageBundleKey(ExoSocialActivity i18nActivity) {
        ActivityResourceBundlePlugin resourceBundlePlugin = this.resourceBundlePluginMap.get(i18nActivity.getType());
        return resourceBundlePlugin.getMessageBundleKey(i18nActivity.getTitleId());
    }

    private boolean getMessageBundleKeys(ExoSocialActivity i18nActivity) {
        String[] keys;
        ActivityResourceBundlePlugin resourceBundlePlugin = this.resourceBundlePluginMap.get(i18nActivity.getType());
        for (String key : keys = I18NActivityUtils.getResourceKeys(i18nActivity)) {
            if (resourceBundlePlugin.getMessageBundleKey(key) == null) continue;
            return true;
        }
        return false;
    }

    private String getMessageBundleKey(String activityType, String resourceBundleKey) {
        ActivityResourceBundlePlugin resourceBundlePlugin = this.resourceBundlePluginMap.get(activityType);
        return resourceBundlePlugin.getMessageBundleKey(resourceBundleKey);
    }

    private String getResourceBundleKeyFile(ExoSocialActivity i18nActivity) {
        return this.resourceBundlePluginMap.get(i18nActivity.getType()).getResourceBundleKeyFile();
    }

    private String appRes(ResourceBundle resourceBundle, String msgKey, Map<String, String> templateParams) {
        String value = this.appRes(resourceBundle, msgKey);
        ArrayList<String> arguments = null;
        if (templateParams != null) {
            arguments = new ArrayList<String>(templateParams.values());
        }
        if (arguments != null && arguments.size() > 0) {
            value = ResourceBundleUtil.replaceArguments((String)value, arguments);
        }
        return value;
    }

    private String appRes(ResourceBundle resourceBundle, String msgKey, String[] values) {
        String value = this.appRes(resourceBundle, msgKey);
        List<String> arguments = null;
        if (values != null) {
            arguments = Arrays.asList(values);
        }
        if (arguments != null && arguments.size() > 0) {
            value = ResourceBundleUtil.replaceArguments((String)value, arguments);
        }
        return value;
    }

    private String appRes(ResourceBundle res, String msgKey) {
        String value = null;
        try {
            value = res.getString(msgKey);
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)("Failed find message bundle value for key : " + msgKey));
        }
        return value;
    }

    private ResourceBundle getResourceBundle(ExoSocialActivity i18nActivity, Locale selectedLocale) {
        if (this.resourceBundleService == null) {
            this.resourceBundleService = (ResourceBundleService)PortalContainer.getInstance().getComponentInstanceOfType(ResourceBundleService.class);
        }
        if (this.resourceBundleService == null) {
            LOG.error((Object)"Failed to get resourceBundleService for I18N activity type.");
            return null;
        }
        if (this.resourceBundlePluginMap == null || this.resourceBundlePluginMap.size() == 0) {
            LOG.warn((Object)"No registered activity resource bundle");
            return null;
        }
        ActivityResourceBundlePlugin resourceBundlePlugin = this.resourceBundlePluginMap.get(i18nActivity.getType());
        return this.resourceBundleService.getResourceBundle(resourceBundlePlugin.getResourceBundleKeyFile(), selectedLocale);
    }
}

