/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.api;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.exoplatform.social.common.service.ProcessContext;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.storage.impl.ActivityStreamStorageImpl;

public interface ActivityStreamStorage {
    public void savePoster(ProcessContext var1);

    public void save(ProcessContext var1);

    public void delete(String var1);

    public void like(Identity var1, ExoSocialActivity var2);

    public void unLike(Identity var1, ExoSocialActivity var2);

    public void connect(Identity var1, Identity var2);

    public void deleteConnect(Identity var1, Identity var2);

    public void update(ProcessContext var1);

    public void updateCommenter(ProcessContext var1);

    public void deleteComment(ProcessContext var1);

    public void addSpaceMember(ProcessContext var1);

    public void removeSpaceMember(ProcessContext var1);

    public List<ExoSocialActivity> getFeed(Identity var1, int var2, int var3);

    public int getNumberOfFeed(Identity var1);

    public boolean hasSizeOfFeed(Identity var1);

    public List<ExoSocialActivity> getConnections(Identity var1, int var2, int var3);

    public int getNumberOfConnections(Identity var1);

    public boolean hasSizeOfConnections(Identity var1);

    public List<ExoSocialActivity> getMySpaces(Identity var1, int var2, int var3);

    public int getNumberOfMySpaces(Identity var1);

    public boolean hasSizeOfMySpaces(Identity var1);

    public List<ExoSocialActivity> getSpaceStream(Identity var1, int var2, int var3);

    public int getNumberOfSpaceStream(Identity var1);

    public boolean hasSizeOfSpaceStream(Identity var1);

    public List<ExoSocialActivity> getMyActivities(Identity var1, int var2, int var3);

    public int getNumberOfMyActivities(Identity var1);

    public boolean hasSizeOfMyActivities(Identity var1);

    public void createActivityRef(Identity var1, List<ExoSocialActivity> var2, ActivityStreamStorageImpl.ActivityRefType var3);

    public void createFeedActivityRef(Identity var1, List<ExoSocialActivity> var2);

    public void createConnectionsActivityRef(Identity var1, List<ExoSocialActivity> var2);

    public void createMySpacesActivityRef(Identity var1, List<ExoSocialActivity> var2);

    public void createSpaceActivityRef(Identity var1, List<ExoSocialActivity> var2);

    public void createMyActivitiesActivityRef(Identity var1, List<ExoSocialActivity> var2);

    public void migrateStreamSize(Identity var1, int var2, ActivityStreamStorageImpl.ActivityRefType var3);

    public static class UpdateContext {
        private List<Identity> added;
        private List<Identity> removed;

        public UpdateContext(List<Identity> added, List<Identity> removed) {
            this.added = added;
            this.removed = removed;
        }

        public UpdateContext(Identity added, Identity removed) {
            if (added != null) {
                this.added = new CopyOnWriteArrayList<Identity>();
                this.added.add(added);
            }
            if (removed != null) {
                this.removed = new CopyOnWriteArrayList<Identity>();
                this.removed.add(removed);
            }
        }

        public List<Identity> getAdded() {
            return this.added == null ? new ArrayList() : this.added;
        }

        public List<Identity> getRemoved() {
            return this.removed == null ? new ArrayList() : this.removed;
        }
    }
}

