/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache;

import java.io.Serializable;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.social.core.storage.cache.FutureExoCache;
import org.exoplatform.social.core.storage.cache.loader.CacheLoader;
import org.exoplatform.social.core.storage.cache.loader.ServiceContext;
import org.exoplatform.social.core.storage.cache.model.key.CacheKey;

public enum CacheType {
    IDENTITY("IdentityCache"),
    IDENTITY_INDEX("IdentityIndexCache"),
    PROFILE("ProfileCache"),
    IDENTITIES_COUNT("IdentitiesCountCache"),
    IDENTITIES("IdentitiesCache"),
    RELATIONSHIP("RelationshipCache"),
    RELATIONSHIP_FROM_IDENTITY("RelationshipFromIdentityCache"),
    RELATIONSHIPS_COUNT("RelationshipsCountCache"),
    RELATIONSHIPS("RelationshipsCache"),
    SUGGESTIONS("SuggestionsCache"),
    ACTIVITY("ActivityCache"),
    ACTIVITIES_COUNT("ActivitiesCountCache"),
    ACTIVITIES("ActivitiesCache"),
    ACTIVITY_REF("ActivityRefCache"),
    ACTIVITIES_REF_COUNT("ActivitiesRefCountCache"),
    ACTIVITIES_REF("ActivitiesRefCache"),
    SPACE("SpaceCache"),
    SPACE_REF("SpaceRefCache"),
    SPACES_COUNT("SpacesCountCache"),
    SPACES("SpacesCache");

    private final String name;

    private CacheType(String name) {
        this.name = name;
    }

    public <K extends CacheKey, V extends Serializable> ExoCache<K, V> getFromService(CacheService service) {
        return service.getCacheInstance(this.name);
    }

    public <K extends CacheKey, V extends Serializable> FutureExoCache<K, V, ServiceContext<V>> createFutureCache(ExoCache<K, V> cache) {
        return new FutureExoCache(new CacheLoader(), cache);
    }
}

