/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache.model.data;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.storage.cache.model.data.CacheData;

public class ActivityData
implements CacheData<ExoSocialActivity> {
    public static final ActivityData NULL = new ActivityData(new ExoSocialActivityImpl());
    private final String id;
    private final String title;
    private final String body;
    private final String[] likes;
    private final boolean isComment;
    private final boolean isHidden;
    private final boolean isLocked;
    private final Long postedTime;
    private final Long lastUpdated;
    private final String[] replyIds;
    private final String userId;
    private final String appId;
    private final String titleId;
    private final String bodyId;
    private final String type;
    private final Map templateParams;
    private final String externalId;
    private final String url;
    private final String streamId;
    private final String streamOwner;
    private final String streamFaviconUrl;
    private final String streamSourceUrl;
    private final String streamTitle;
    private final String streamUrl;
    private final String[] mentioners;
    private final String[] commenters;
    private final ActivityStream.Type streamType;
    private final String posterId;

    public ActivityData(ExoSocialActivity activity) {
        this.id = activity.getId();
        this.title = activity.getTitle();
        this.body = activity.getBody();
        this.likes = activity.getLikeIdentityIds();
        this.isComment = activity.isComment();
        this.isHidden = activity.isHidden();
        this.isLocked = activity.isLocked();
        this.postedTime = activity.getPostedTime();
        this.lastUpdated = activity.getUpdated().getTime();
        this.replyIds = activity.getReplyToId();
        this.userId = activity.getUserId();
        this.appId = activity.getAppId();
        this.titleId = activity.getTitleId();
        this.bodyId = activity.getBodyId();
        this.type = activity.getType();
        this.externalId = activity.getExternalId();
        this.url = activity.getUrl();
        this.streamId = activity.getStreamId();
        this.streamOwner = activity.getStreamOwner();
        this.streamFaviconUrl = activity.getStreamFaviconUrl();
        this.streamSourceUrl = activity.getStreamSourceUrl();
        this.streamTitle = activity.getStreamTitle();
        this.streamUrl = activity.getStreamUrl();
        this.mentioners = activity.getMentionedIds();
        this.commenters = activity.getCommentedIds();
        this.streamType = activity.getActivityStream().getType();
        this.posterId = activity.getPosterId();
        this.templateParams = activity.getTemplateParams() != null ? Collections.unmodifiableMap(activity.getTemplateParams()) : Collections.emptyMap();
    }

    @Override
    public ExoSocialActivity build() {
        if (this == NULL) {
            return null;
        }
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setId(this.id);
        activity.setTitle(this.title);
        activity.setBody(this.body);
        if (this.likes != null) {
            activity.setLikeIdentityIds(this.likes);
        }
        activity.setReplyToId(this.replyIds);
        activity.isComment(this.isComment);
        activity.isHidden(this.isHidden);
        activity.isLocked(this.isLocked);
        activity.setPostedTime(this.postedTime);
        activity.setUpdated(new Date(this.lastUpdated));
        activity.setUserId(this.userId);
        activity.setAppId(this.appId);
        activity.setTitleId(this.titleId);
        activity.setBodyId(this.bodyId);
        activity.setType(this.type);
        activity.setTemplateParams(new LinkedHashMap(this.templateParams));
        activity.setExternalId(this.externalId);
        activity.setUrl(this.url);
        if (this.mentioners != null) {
            activity.setMentionedIds(this.mentioners);
        }
        if (this.commenters != null) {
            activity.setCommentedIds(this.commenters);
        }
        activity.setPosterId(this.posterId);
        ActivityStream activityStream = activity.getActivityStream();
        activityStream.setId(this.streamId);
        activityStream.setPrettyId(this.streamOwner);
        activityStream.setFaviconUrl(this.streamFaviconUrl);
        activityStream.setPermaLink(this.streamSourceUrl);
        activityStream.setTitle(this.streamTitle);
        activityStream.setType(this.streamType);
        activity.setActivityStream(activityStream);
        return activity;
    }

    public String getUserId() {
        return this.userId;
    }
}

