/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.apache.commons.lang.ArrayUtils;
import org.chromattic.api.query.Ordering;
import org.chromattic.api.query.QueryBuilder;
import org.chromattic.api.query.QueryResult;
import org.chromattic.core.query.QueryImpl;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.chromattic.entity.IdentityEntity;
import org.exoplatform.social.core.chromattic.entity.ProfileEntity;
import org.exoplatform.social.core.chromattic.entity.RelationshipEntity;
import org.exoplatform.social.core.chromattic.entity.RelationshipListEntity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.storage.RelationshipStorageException;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.api.ActivityStreamStorage;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.api.RelationshipStorage;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;
import org.exoplatform.social.core.storage.cache.CachedActivityStreamStorage;
import org.exoplatform.social.core.storage.exception.NodeNotFoundException;
import org.exoplatform.social.core.storage.impl.AbstractStorage;
import org.exoplatform.social.core.storage.impl.StorageUtils;
import org.exoplatform.social.core.storage.query.JCRProperties;
import org.exoplatform.social.core.storage.query.WhereExpression;
import org.exoplatform.social.core.storage.streams.StreamInvocationHelper;
import org.exoplatform.social.core.storage.thread.SocialExecutorService;

public class RelationshipStorageImpl
extends AbstractStorage
implements RelationshipStorage {
    private static final Log LOG = ExoLogger.getLogger(RelationshipStorage.class);
    private final IdentityStorage identityStorage;
    private RelationshipStorage relationshipStorage;
    private CachedActivityStorage cachedActivityStorage;
    private Object lock = new Object();
    private CachedActivityStreamStorage streamStorage;
    private SocialExecutorService<String[]> executorService = new SocialExecutorService(10);

    public RelationshipStorageImpl(IdentityStorage identityStorage) {
        this.identityStorage = identityStorage;
    }

    private CachedActivityStorage getCachedActivityStorage() {
        if (this.cachedActivityStorage == null) {
            PortalContainer container = PortalContainer.getInstance();
            this.cachedActivityStorage = (CachedActivityStorage)container.getComponentInstanceOfType(ActivityStorage.class);
        }
        return this.cachedActivityStorage;
    }

    private CachedActivityStreamStorage getCachedActivityStreamStorage() {
        if (this.streamStorage == null) {
            PortalContainer container = PortalContainer.getInstance();
            this.streamStorage = (CachedActivityStreamStorage)container.getComponentInstanceOfType(ActivityStreamStorage.class);
        }
        return this.streamStorage;
    }

    private void putRelationshipToList(List<Relationship> relationships, RelationshipListEntity list) {
        if (list != null) {
            for (Map.Entry<String, RelationshipEntity> entry : list.getRelationships().entrySet()) {
                Relationship relationship = new Relationship(entry.getValue().getId());
                RelationshipEntity relationshipEntity = entry.getValue();
                IdentityEntity senderEntity = relationshipEntity.getFrom();
                IdentityEntity receiverEntity = relationshipEntity.getTo();
                Identity sender = new Identity(senderEntity.getId());
                sender.setRemoteId(senderEntity.getRemoteId());
                sender.setProviderId(senderEntity.getProviderId());
                ProfileEntity senderProfileEntity = senderEntity.getProfile();
                if (senderProfileEntity != null) {
                    this.loadProfile(sender);
                }
                Identity receiver = new Identity(receiverEntity.getId());
                receiver.setRemoteId(receiverEntity.getRemoteId());
                receiver.setProviderId(receiverEntity.getProviderId());
                ProfileEntity receiverProfileEntity = receiverEntity.getProfile();
                if (receiverProfileEntity != null) {
                    this.loadProfile(receiver);
                }
                if (relationshipEntity.isSender()) {
                    relationship.setSender(sender);
                    relationship.setReceiver(receiver);
                } else {
                    relationship.setSender(receiver);
                    relationship.setReceiver(sender);
                }
                if ("sender".equals(entry.getValue().getParent().getName()) || "receiver".equals(entry.getValue().getParent().getName())) {
                    relationship.setStatus(Relationship.Type.PENDING);
                } else {
                    relationship.setStatus(Relationship.Type.CONFIRMED);
                }
                relationships.add(relationship);
            }
        }
    }

    private void loadProfile(Identity identity) {
        Profile profile = new Profile(identity);
        profile = this.identityStorage.loadProfile(profile);
        identity.setProfile(profile);
    }

    private List<Identity> getIdentitiesFromRelationship(Iterator<RelationshipEntity> it, Origin origin, long offset, long limit) {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        int i = 0;
        this._skip(it, offset);
        Identity identity = null;
        while (it.hasNext()) {
            RelationshipEntity relationshipEntity = it.next();
            switch (origin) {
                case FROM: {
                    identity = this.createIdentityFromEntity(relationshipEntity.getFrom());
                    if (identities.indexOf(identity) != -1) break;
                    identities.add(identity);
                    break;
                }
                case TO: {
                    identity = this.createIdentityFromEntity(relationshipEntity.getTo());
                    if (identities.indexOf(identity) != -1) break;
                    identities.add(identity);
                }
            }
            if (limit == -1L || limit <= 0L || (long)(++i) < limit) continue;
            break;
        }
        return identities;
    }

    private Identity createIdentityFromEntity(IdentityEntity entity) {
        Identity identity = this.identityStorage.findIdentityById(entity.getId());
        this.loadProfile(identity);
        return identity;
    }

    private List<Identity> getIdentitiesRelationsByFilter(List<Identity> relations, ProfileFilter filter, long offset, long limit) {
        if (relations.isEmpty()) {
            return new ArrayList<Identity>();
        }
        ArrayList<Identity> found = new ArrayList<Identity>();
        if (relations.isEmpty()) {
            return found;
        }
        QueryBuilder builder = this.getSession().createQueryBuilder(ProfileEntity.class);
        WhereExpression whereExpression = new WhereExpression();
        StorageUtils.applyWhereFromIdentity(whereExpression, relations);
        StorageUtils.applyFilter(whereExpression, filter);
        builder.where(whereExpression.toString()).orderBy(ProfileEntity.fullName.getName(), Ordering.ASC);
        QueryImpl queryImpl = (QueryImpl)builder.get();
        ((org.exoplatform.services.jcr.impl.core.query.QueryImpl)queryImpl.getNativeQuery()).setCaseInsensitiveOrder(true);
        QueryResult result = queryImpl.objects(Long.valueOf(offset), Long.valueOf(limit));
        while (result.hasNext()) {
            IdentityEntity current = ((ProfileEntity)result.next()).getIdentity();
            Identity i = new Identity(current.getProviderId(), current.getRemoteId());
            i.setId(current.getId());
            found.add(i);
        }
        return found;
    }

    private int getIdentitiesRelationsByFilterCount(List<Identity> relations, ProfileFilter filter) {
        if (relations.size() == 0) {
            return 0;
        }
        QueryBuilder builder = this.getSession().createQueryBuilder(ProfileEntity.class);
        WhereExpression whereExpression = new WhereExpression();
        StorageUtils.applyWhereFromIdentity(whereExpression, relations);
        StorageUtils.applyFilter(whereExpression, filter);
        return builder.where(whereExpression.toString()).get().objects().size();
    }

    private RelationshipStorage getStorage() {
        return this.relationshipStorage != null ? this.relationshipStorage : this;
    }

    protected RelationshipEntity _createRelationship(Relationship relationship) throws NodeNotFoundException {
        String identityId1 = relationship.getSender().getId();
        String identityId2 = relationship.getReceiver().getId();
        IdentityEntity identity1 = this._findById(IdentityEntity.class, identityId1);
        IdentityEntity identity2 = this._findById(IdentityEntity.class, identityId2);
        RelationshipEntity createdRelationship = identity1.createRelationship();
        RelationshipEntity symmetricalRelationship = identity1.createRelationship();
        switch (relationship.getStatus()) {
            case PENDING: {
                identity1.getSender().getRelationships().put(identity2.getRemoteId(), createdRelationship);
                identity2.getReceiver().getRelationships().put(identity1.getRemoteId(), symmetricalRelationship);
                break;
            }
            case CONFIRMED: {
                identity1.getRelationship().getRelationships().put(identity2.getRemoteId(), createdRelationship);
                identity2.getRelationship().getRelationships().put(identity1.getRemoteId(), symmetricalRelationship);
                break;
            }
            case IGNORED: {
                identity1.getIgnore().getRelationships().put(identity2.getRemoteId(), createdRelationship);
                identity2.getIgnored().getRelationships().put(identity2.getRemoteId(), symmetricalRelationship);
            }
        }
        long createdTimeStamp = System.currentTimeMillis();
        createdRelationship.setFrom(identity1);
        createdRelationship.setTo(identity2);
        createdRelationship.setReciprocal(symmetricalRelationship);
        createdRelationship.setStatus(relationship.getStatus().toString());
        createdRelationship.setCreatedTime(createdTimeStamp);
        symmetricalRelationship.setFrom(identity2);
        symmetricalRelationship.setTo(identity1);
        symmetricalRelationship.setReciprocal(createdRelationship);
        symmetricalRelationship.setStatus(relationship.getStatus().toString());
        symmetricalRelationship.setCreatedTime(createdTimeStamp);
        relationship.setId(createdRelationship.getId());
        this.getSession().save();
        LOG.debug((Object)String.format("Relationship from %s:%s to %s:%s created (%s)", createdRelationship.getFrom().getProviderId(), createdRelationship.getFrom().getRemoteId(), createdRelationship.getTo().getProviderId(), createdRelationship.getTo().getRemoteId(), createdRelationship.getPath()));
        LOG.debug((Object)String.format("Symmetrical relationship from %s:%s to %s:%s created (%s)", symmetricalRelationship.getFrom().getProviderId(), symmetricalRelationship.getFrom().getRemoteId(), symmetricalRelationship.getTo().getProviderId(), symmetricalRelationship.getTo().getRemoteId(), symmetricalRelationship.getPath()));
        return createdRelationship;
    }

    protected RelationshipEntity _saveRelationship(Relationship relationship) throws NodeNotFoundException {
        RelationshipEntity savedRelationship = this._findById(RelationshipEntity.class, relationship.getId());
        RelationshipEntity symmetricalRelationship = savedRelationship.getReciprocal();
        savedRelationship.setStatus(relationship.getStatus().toString());
        symmetricalRelationship.setStatus(relationship.getStatus().toString());
        switch (relationship.getStatus()) {
            case PENDING: {
                savedRelationship.getParent().getParent().getSender().getRelationships().put(savedRelationship.getName(), savedRelationship);
                symmetricalRelationship.getParent().getParent().getReceiver().getRelationships().put(symmetricalRelationship.getName(), symmetricalRelationship);
                break;
            }
            case CONFIRMED: {
                savedRelationship.getParent().getParent().getRelationship().getRelationships().put(savedRelationship.getName(), savedRelationship);
                symmetricalRelationship.getParent().getParent().getRelationship().getRelationships().put(symmetricalRelationship.getName(), symmetricalRelationship);
                StreamInvocationHelper.connect(relationship.getSender(), relationship.getReceiver());
            }
        }
        this.getSession().save();
        LOG.debug((Object)String.format("Relationship from %s:%s to %s:%s saved (%s)", savedRelationship.getFrom().getProviderId(), savedRelationship.getFrom().getRemoteId(), savedRelationship.getTo().getProviderId(), savedRelationship.getTo().getRemoteId(), savedRelationship.getPath()));
        LOG.debug((Object)String.format("Symmetrical relationship from %s:%s to %s:%s saved (%s)", symmetricalRelationship.getFrom().getProviderId(), symmetricalRelationship.getFrom().getRemoteId(), symmetricalRelationship.getTo().getProviderId(), symmetricalRelationship.getTo().getRemoteId(), symmetricalRelationship.getPath()));
        return savedRelationship;
    }

    protected List<Relationship> _getSenderRelationships(Identity sender, Relationship.Type type, List<Identity> listCheckIdentity) throws NodeNotFoundException {
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        IdentityEntity senderEntity = this._findById(IdentityEntity.class, sender.getId());
        if (type == null) {
            this.putRelationshipToList(relationships, senderEntity.getRelationship());
            this.putRelationshipToList(relationships, senderEntity.getSender());
        } else {
            switch (type) {
                case CONFIRMED: {
                    this.putRelationshipToList(relationships, senderEntity.getRelationship());
                    break;
                }
                case PENDING: {
                    this.putRelationshipToList(relationships, senderEntity.getSender());
                }
            }
        }
        return relationships;
    }

    protected List<Relationship> _getReceiverRelationships(Identity receiver, Relationship.Type type, List<Identity> listCheckIdentity) throws NodeNotFoundException {
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        IdentityEntity receiverEntity = this._findById(IdentityEntity.class, receiver.getId());
        if (type == null) {
            this.putRelationshipToList(relationships, receiverEntity.getRelationship());
            this.putRelationshipToList(relationships, receiverEntity.getReceiver());
        } else {
            switch (type) {
                case CONFIRMED: {
                    this.putRelationshipToList(relationships, receiverEntity.getRelationship());
                    break;
                }
                case PENDING: {
                    this.putRelationshipToList(relationships, receiverEntity.getReceiver());
                }
            }
        }
        return relationships;
    }

    protected Relationship _getRelationship(String uuid) throws NodeNotFoundException {
        RelationshipEntity relationshipEntity = this._findById(RelationshipEntity.class, uuid);
        IdentityEntity receiverEntity = relationshipEntity.getTo();
        IdentityEntity senderEntity = relationshipEntity.getFrom();
        Identity receiver = this.identityStorage.findIdentityById(receiverEntity.getId());
        Identity sender = this.identityStorage.findIdentityById(senderEntity.getId());
        Relationship relationship = new Relationship(uuid);
        if (relationshipEntity.isReceiver()) {
            relationship.setSender(receiver);
            relationship.setReceiver(sender);
        } else {
            relationship.setSender(sender);
            relationship.setReceiver(receiver);
        }
        if ("sender".equals(relationshipEntity.getParent().getName()) || "receiver".equals(relationshipEntity.getParent().getName())) {
            relationship.setStatus(Relationship.Type.PENDING);
        } else {
            relationship.setStatus(Relationship.Type.CONFIRMED);
        }
        return relationship;
    }

    protected Relationship _getRelationship(Identity identity1, Identity identity2) throws RelationshipStorageException, NodeNotFoundException {
        IdentityEntity identityEntity1 = this._findById(IdentityEntity.class, identity1.getId());
        IdentityEntity identityEntity2 = this._findById(IdentityEntity.class, identity2.getId());
        RelationshipEntity got = identityEntity1.getRelationship().getRelationships().get(identityEntity2.getName());
        if (got == null) {
            got = identityEntity1.getSender().getRelationships().get(identity2.getRemoteId());
        }
        if (got == null) {
            got = identityEntity2.getSender().getRelationships().get(identity1.getRemoteId());
        }
        if (got == null) {
            throw new NodeNotFoundException();
        }
        Relationship relationship = new Relationship(got.getId());
        IdentityEntity senderEntity = got.getFrom();
        IdentityEntity receiverEntity = got.getTo();
        Identity sender = new Identity(senderEntity.getId());
        sender.setRemoteId(senderEntity.getRemoteId());
        sender.setProviderId(senderEntity.getProviderId());
        Identity receiver = new Identity(receiverEntity.getId());
        receiver.setRemoteId(receiverEntity.getRemoteId());
        receiver.setProviderId(receiverEntity.getProviderId());
        relationship.setSender(sender);
        relationship.setReceiver(receiver);
        relationship.setStatus(Relationship.Type.valueOf(got.getStatus()));
        return relationship;
    }

    @Override
    public Relationship saveRelationship(Relationship relationship) throws RelationshipStorageException {
        try {
            if (relationship.getId() == null) {
                this._createRelationship(relationship);
            } else {
                this._saveRelationship(relationship);
            }
        }
        catch (NodeNotFoundException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.ILLEGAL_ARGUMENTS, new String[]{Relationship.class.getSimpleName()});
        }
        return relationship;
    }

    @Override
    public void removeRelationship(Relationship relationship) throws RelationshipStorageException {
        try {
            RelationshipEntity toDeleteRelationship = this._findById(RelationshipEntity.class, relationship.getId());
            RelationshipEntity symmetricalRelationship = toDeleteRelationship.getReciprocal();
            IdentityEntity from = toDeleteRelationship.getFrom();
            IdentityEntity to = toDeleteRelationship.getFrom();
            this._removeById(RelationshipEntity.class, symmetricalRelationship.getId());
            this._removeById(RelationshipEntity.class, relationship.getId());
            StorageUtils.persist();
            StreamInvocationHelper.deleteConnect(relationship.getSender(), relationship.getReceiver());
            this.getCachedActivityStorage().clearCache();
            LOG.debug((Object)String.format("Symmetrical relationship from %s:%s to %s:%s removed", to.getProviderId(), to.getRemoteId(), from.getProviderId(), from.getRemoteId()));
            LOG.debug((Object)String.format("Relationship from %s:%s to %s:%s removed", from.getProviderId(), from.getRemoteId(), to.getProviderId(), to.getRemoteId()));
        }
        catch (NodeNotFoundException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_GET_RELATIONSHIP);
        }
    }

    @Override
    public Relationship getRelationship(String uuid) throws RelationshipStorageException {
        try {
            return this._getRelationship(uuid);
        }
        catch (NodeNotFoundException e) {
            return null;
        }
    }

    @Override
    public List<Relationship> getSenderRelationships(Identity sender, Relationship.Type type, List<Identity> listCheckIdentity) throws RelationshipStorageException {
        try {
            return this._getSenderRelationships(sender, type, listCheckIdentity);
        }
        catch (NodeNotFoundException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_GET_RELATIONSHIP, null, e, sender.getId(), type.toString());
        }
    }

    @Override
    public List<Relationship> getSenderRelationships(String senderId, Relationship.Type type, List<Identity> listCheckIdentity) throws RelationshipStorageException {
        return this.getSenderRelationships(new Identity(senderId), type, listCheckIdentity);
    }

    @Override
    public List<Relationship> getReceiverRelationships(Identity receiver, Relationship.Type type, List<Identity> listCheckIdentity) throws RelationshipStorageException {
        try {
            return this._getReceiverRelationships(receiver, type, listCheckIdentity);
        }
        catch (NodeNotFoundException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_GET_RELATIONSHIP, null, e, receiver.getId(), type.toString());
        }
    }

    @Override
    public Relationship getRelationship(Identity identity1, Identity identity2) throws RelationshipStorageException {
        try {
            return this._getRelationship(identity1, identity2);
        }
        catch (NodeNotFoundException e) {
            return null;
        }
    }

    @Override
    public List<Relationship> getRelationships(Identity identity, Relationship.Type type, List<Identity> listCheckIdentity) throws RelationshipStorageException {
        try {
            ArrayList<Relationship> relationships = new ArrayList<Relationship>();
            IdentityEntity receiverEntity = this._findById(IdentityEntity.class, identity.getId());
            if (type == null) {
                this.putRelationshipToList(relationships, receiverEntity.getRelationship());
                this.putRelationshipToList(relationships, receiverEntity.getReceiver());
                this.putRelationshipToList(relationships, receiverEntity.getSender());
            } else {
                switch (type) {
                    case CONFIRMED: {
                        this.putRelationshipToList(relationships, receiverEntity.getRelationship());
                        break;
                    }
                    case PENDING: {
                        this.putRelationshipToList(relationships, receiverEntity.getReceiver());
                        this.putRelationshipToList(relationships, receiverEntity.getSender());
                        break;
                    }
                    case IGNORED: {
                        this.putRelationshipToList(relationships, receiverEntity.getIgnored());
                    }
                }
            }
            return relationships;
        }
        catch (NodeNotFoundException e) {
            return new ArrayList<Relationship>();
        }
    }

    @Override
    public List<Identity> getRelationships(Identity identity, long offset, long limit) throws RelationshipStorageException {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        try {
            IdentityEntity identityEntity = this._findById(IdentityEntity.class, identity.getId());
            QueryBuilder builder = this.getSession().createQueryBuilder(RelationshipEntity.class);
            WhereExpression whereExpression = new WhereExpression();
            whereExpression.like(JCRProperties.path, identityEntity.getPath() + "/" + "%");
            builder.where(whereExpression.toString());
            builder.orderBy(RelationshipEntity.createdTime.getName(), Ordering.DESC);
            QueryResult results = builder.get().objects(Long.valueOf(offset), Long.valueOf(limit));
            while (results.hasNext()) {
                RelationshipEntity currentRelationshipEntity = (RelationshipEntity)results.next();
                IdentityEntity gotIdentityEntity = currentRelationshipEntity.isReceiver() ? currentRelationshipEntity.getFrom() : currentRelationshipEntity.getTo();
                Identity newIdentity = new Identity(gotIdentityEntity.getId());
                newIdentity.setProviderId(gotIdentityEntity.getProviderId());
                newIdentity.setRemoteId(gotIdentityEntity.getRemoteId());
                identities.add(newIdentity);
            }
        }
        catch (NodeNotFoundException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_GET_RELATIONSHIP, e.getMessage());
        }
        return identities;
    }

    @Override
    public List<Identity> getIncomingRelationships(Identity receiver, long offset, long limit) throws RelationshipStorageException {
        try {
            IdentityEntity receiverEntity = this._findById(IdentityEntity.class, receiver.getId());
            Iterator<RelationshipEntity> it = receiverEntity.getReceiver().getRelationships().values().iterator();
            return this.getIdentitiesFromRelationship(it, Origin.TO, offset, limit);
        }
        catch (NodeNotFoundException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_GET_RELATIONSHIP, e.getMessage());
        }
    }

    @Override
    public int getIncomingRelationshipsCount(Identity receiver) throws RelationshipStorageException {
        try {
            IdentityEntity receiverEntity = this._findById(IdentityEntity.class, receiver.getId());
            return receiverEntity.getReceiver().getRelationships().size();
        }
        catch (NodeNotFoundException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_GET_RELATIONSHIP, e.getMessage());
        }
    }

    @Override
    public List<Identity> getOutgoingRelationships(Identity sender, long offset, long limit) throws RelationshipStorageException {
        try {
            IdentityEntity senderEntity = this._findById(IdentityEntity.class, sender.getId());
            Iterator<RelationshipEntity> it = senderEntity.getSender().getRelationships().values().iterator();
            return this.getIdentitiesFromRelationship(it, Origin.TO, offset, limit);
        }
        catch (NodeNotFoundException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_GET_RELATIONSHIP, e.getMessage());
        }
    }

    @Override
    public int getOutgoingRelationshipsCount(Identity sender) throws RelationshipStorageException {
        try {
            IdentityEntity receiverEntity = this._findById(IdentityEntity.class, sender.getId());
            return receiverEntity.getSender().getRelationships().size();
        }
        catch (NodeNotFoundException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_GET_RELATIONSHIP, e.getMessage());
        }
    }

    @Override
    public int getRelationshipsCount(Identity identity) throws RelationshipStorageException {
        int nb = 0;
        try {
            IdentityEntity identityEntity = this._findById(IdentityEntity.class, identity.getId());
            nb += identityEntity.getRelationship().getRelationships().size();
            nb += identityEntity.getSender().getRelationships().size();
            nb += identityEntity.getReceiver().getRelationships().size();
            return nb += identityEntity.getIgnore().getRelationships().size();
        }
        catch (NodeNotFoundException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_GET_RELATIONSHIP, e.getMessage());
        }
    }

    @Override
    public List<Identity> getConnections(Identity identity, long offset, long limit) throws RelationshipStorageException {
        try {
            IdentityEntity identityEntity = this._findById(IdentityEntity.class, identity.getId());
            Iterator<RelationshipEntity> it = identityEntity.getRelationship().getRelationships().values().iterator();
            return this.getIdentitiesFromRelationship(it, Origin.TO, offset, limit);
        }
        catch (NodeNotFoundException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.ILLEGAL_ARGUMENTS);
        }
    }

    @Override
    public List<Identity> getConnections(Identity identity) throws RelationshipStorageException {
        return this.getConnections(identity, 0L, -1L);
    }

    @Override
    public int getConnectionsCount(Identity identity) throws RelationshipStorageException {
        try {
            IdentityEntity identityEntity = this._findById(IdentityEntity.class, identity.getId());
            return identityEntity.getRelationship().getRelationships().size();
        }
        catch (NodeNotFoundException e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.ILLEGAL_ARGUMENTS);
        }
    }

    @Override
    public List<Identity> getConnectionsByFilter(Identity existingIdentity, ProfileFilter profileFilter, long offset, long limit) throws RelationshipStorageException {
        List<Identity> identities = this.getStorage().getConnections(existingIdentity);
        return this.getIdentitiesRelationsByFilter(identities, profileFilter, offset, limit);
    }

    @Override
    public List<Identity> getIncomingByFilter(Identity existingIdentity, ProfileFilter profileFilter, long offset, long limit) throws RelationshipStorageException {
        List<Identity> identities = this.getStorage().getIncomingRelationships(existingIdentity, 0L, -1L);
        return this.getIdentitiesRelationsByFilter(identities, profileFilter, offset, limit);
    }

    @Override
    public List<Identity> getOutgoingByFilter(Identity existingIdentity, ProfileFilter profileFilter, long offset, long limit) throws RelationshipStorageException {
        List<Identity> identities = this.getStorage().getOutgoingRelationships(existingIdentity, 0L, -1L);
        return this.getIdentitiesRelationsByFilter(identities, profileFilter, offset, limit);
    }

    @Override
    public int getIncomingCountByFilter(Identity existingIdentity, ProfileFilter profileFilter) throws RelationshipStorageException {
        List<Identity> identities = this.getStorage().getIncomingRelationships(existingIdentity, 0L, -1L);
        return this.getIdentitiesRelationsByFilterCount(identities, profileFilter);
    }

    @Override
    public int getConnectionsCountByFilter(Identity existingIdentity, ProfileFilter profileFilter) throws RelationshipStorageException {
        List<Identity> identities = this.getStorage().getConnections(existingIdentity);
        return this.getIdentitiesRelationsByFilterCount(identities, profileFilter);
    }

    @Override
    public int getOutgoingCountByFilter(Identity existingIdentity, ProfileFilter profileFilter) throws RelationshipStorageException {
        List<Identity> identities = this.getStorage().getOutgoingRelationships(existingIdentity, 0L, -1L);
        return this.getIdentitiesRelationsByFilterCount(identities, profileFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getRelationships(String id) {
        ThreadLocal<String[]> identityIdsLocal = new ThreadLocal<String[]>();
        String[] relationshipIds = new String[]{};
        identityIdsLocal.set(relationshipIds);
        try {
            IdentityEntity identityEntity = this._findById(IdentityEntity.class, id);
            StringBuffer sb = new StringBuffer().append("SELECT * FROM soc:relationshipdefinition WHERE ");
            sb.append(JCRProperties.path.getName()).append(" LIKE '").append(identityEntity.getPath() + "/" + "%").append("'");
            sb.append(" ORDER BY ").append(RelationshipEntity.createdTime.getName()).append(" DESC ");
            Object object = this.lock;
            synchronized (object) {
                NodeIterator it = this.nodes(sb.toString());
                while (it.hasNext()) {
                    Node node = (Node)it.next();
                    RelationshipEntity currentRelationshipEntity = this._findById(RelationshipEntity.class, node.getUUID());
                    IdentityEntity gotIdentityEntity = currentRelationshipEntity.isReceiver() ? currentRelationshipEntity.getFrom() : currentRelationshipEntity.getTo();
                    identityIdsLocal.set((String[])ArrayUtils.add((Object[])((Object[])identityIdsLocal.get()), (Object)gotIdentityEntity.getId()));
                }
            }
        }
        catch (Exception e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_GET_RELATIONSHIP, e.getMessage());
        }
        return (String[])identityIdsLocal.get();
    }

    private String[] getSuggestion(List<String> relationshipIds) {
        Object[] suggestions = new String[]{};
        try {
            int startIndex = 0;
            int toIndex = 100;
            List<String> excludeIdentities = StorageUtils.subList(relationshipIds, startIndex, toIndex);
            while (excludeIdentities.size() > 0) {
                StringBuffer sb = new StringBuffer().append("SELECT * FROM soc:identitydefinition WHERE ");
                sb.append(JCRProperties.path.getName()).append(" LIKE '").append(this.getProviderRoot().getProviders().get("organization").getPath() + "/" + "%").append("'");
                sb.append(" AND soc:isDeleted = 'false'");
                for (String id : excludeIdentities) {
                    sb.append(" AND NOT ").append(JCRProperties.id.getName()).append(" = '").append(id).append("'");
                }
                NodeIterator nodeIter = this.nodes(sb.toString());
                while (nodeIter.hasNext()) {
                    Node node = (Node)nodeIter.next();
                    String id = node.getUUID();
                    if (relationshipIds.contains(id) || ArrayUtils.contains((Object[])suggestions, (Object)id)) continue;
                    suggestions = (String[])ArrayUtils.add((Object[])suggestions, (Object)id);
                }
                startIndex = toIndex;
                excludeIdentities = StorageUtils.subList(relationshipIds, startIndex, toIndex += 100);
            }
        }
        catch (Exception e) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_GET_RELATIONSHIP, e.getMessage());
        }
        return suggestions;
    }

    private Map<String, String[]> getSuggestionRelationships(String[] suggestions) {
        for (final String id : suggestions) {
            Callable<String[]> task = new Callable<String[]>(){

                @Override
                public String[] call() throws Exception {
                    return RelationshipStorageImpl.this.getRelationships(id);
                }
            };
            this.executorService.submit(task, id);
        }
        HashMap<String, String[]> suggestRelationships = new HashMap<String, String[]>();
        this.copyFutureToMap(suggestRelationships, this.executorService.getFutureCollections());
        return suggestRelationships;
    }

    private void copyFutureToMap(Map<String, String[]> map, Map<String, Future<String[]>> futures) {
        try {
            for (Map.Entry<String, Future<String[]>> future : futures.entrySet()) {
                map.put(future.getKey(), future.getValue().get());
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to get result from Future." + e));
        }
    }

    private Map<String, Integer> statisticSuggesstion(List<String> relationshipIds, Map<String, String[]> suggestRelationships) {
        HashMap<String, Integer> suggestionIdMap = new HashMap<String, Integer>();
        for (Map.Entry<String, String[]> friendOfIdentity : suggestRelationships.entrySet()) {
            String identityId = friendOfIdentity.getKey();
            suggestionIdMap.put(identityId, StorageUtils.getCommonItemNumber(relationshipIds, Arrays.asList((Object[])friendOfIdentity.getValue())));
        }
        return suggestionIdMap;
    }

    @Override
    public Map<Identity, Integer> getSuggestions(Identity identity, int offset, int limit) throws RelationshipStorageException {
        ArrayList<String> relationshipIds = new ArrayList<String>();
        relationshipIds.add(identity.getId());
        relationshipIds.addAll(Arrays.asList(this.getRelationships(identity.getId())));
        String[] suggestions = this.getSuggestion(relationshipIds);
        Map<String, String[]> suggestRelationships = this.getSuggestionRelationships(suggestions);
        Map<String, Integer> suggestionIdMap = this.statisticSuggesstion(relationshipIds, suggestRelationships);
        if (offset > suggestionIdMap.size()) {
            return Collections.emptyMap();
        }
        return this.buildSuggestions(StorageUtils.sortMapByValue(suggestionIdMap, false), offset, limit);
    }

    private Map<Identity, Integer> buildSuggestions(Map<String, Integer> mapIds, int offset, int limit) {
        LinkedHashMap<Identity, Integer> suggestions = new LinkedHashMap<Identity, Integer>();
        int i = 0;
        for (Map.Entry<String, Integer> id : mapIds.entrySet()) {
            if (i < offset) {
                ++i;
                continue;
            }
            if (i > offset + limit) break;
            try {
                IdentityEntity identityEntity = this._findById(IdentityEntity.class, id.getKey());
                Identity _identity = new Identity(id.getKey());
                _identity.setDeleted(identityEntity.isDeleted());
                _identity.setRemoteId(identityEntity.getRemoteId());
                _identity.setProviderId(identityEntity.getProviderId());
                this.loadProfile(_identity);
                suggestions.put(_identity, id.getValue());
            }
            catch (NodeNotFoundException e) {
                LOG.warn((Object)("Could not found identity with id = " + id.getKey()));
            }
            ++i;
        }
        return suggestions;
    }

    public void setStorage(RelationshipStorage storage) {
        this.relationshipStorage = storage;
    }

    private static enum Origin {
        FROM,
        TO;

    }
}

