/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.streams;

import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.common.service.ProcessContext;
import org.exoplatform.social.common.service.Processor;
import org.exoplatform.social.common.service.SocialServiceContext;

public abstract class SocialChromatticSyncProcessor
implements Processor {
    protected SocialServiceContext socialContext;
    final String name;
    protected final PortalContainer container;
    protected ChromatticManager manager;
    protected ChromatticLifeCycle lifeCycle;

    public SocialChromatticSyncProcessor(SocialServiceContext socialContext) {
        this("SocialChromatticSyncProcessor", socialContext);
    }

    public SocialChromatticSyncProcessor(String name, SocialServiceContext socialContext) {
        this.socialContext = socialContext;
        this.name = name;
        this.container = PortalContainer.getInstance();
        this.manager = (ChromatticManager)this.container.getComponentInstanceOfType(ChromatticManager.class);
        if (this.manager != null) {
            this.lifeCycle = this.manager.getLifeCycle("soc");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessContext process(ProcessContext processContext) {
        try {
            this.start(processContext);
            processContext = this.execute(processContext);
        }
        catch (Exception e) {
            processContext.setException((Throwable)e);
        }
        finally {
            this.end(processContext);
        }
        return processContext;
    }

    protected abstract ProcessContext execute(ProcessContext var1) throws Exception;

    public void start(ProcessContext processContext) {
        processContext.getTraceElement().start();
    }

    public void end(ProcessContext processContext) {
        processContext.getTraceElement().end();
    }

    public String getName() {
        return this.name;
    }
}

