/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.compiler.file;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import juzu.impl.common.FileKey;
import juzu.impl.compiler.file.FileManager;
import juzu.impl.compiler.file.SimpleFileManager;
import juzu.impl.fs.spi.ReadFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeFileManager
extends FileManager {
    private FileManager[] components;

    public CompositeFileManager(StandardLocation location, Collection<ReadFileSystem<?>> fsList) {
        FileManager[] components = new FileManager[fsList.size()];
        int index = 0;
        for (ReadFileSystem<?> fs : fsList) {
            components[index++] = SimpleFileManager.wrap(location, fs);
        }
        this.components = components;
    }

    @Override
    public void populateRoots(Set<File> roots) throws IOException {
        for (FileManager component : this.components) {
            component.populateRoots(roots);
        }
    }

    @Override
    public JavaFileObject getReadable(FileKey key) throws IOException {
        for (FileManager component : this.components) {
            JavaFileObject readable = component.getReadable(key);
            if (readable == null) continue;
            return readable;
        }
        return null;
    }

    @Override
    public JavaFileObject getWritable(FileKey key) throws IOException {
        for (FileManager component : this.components) {
            JavaFileObject writable = component.getWritable(key);
            if (writable == null) continue;
            return writable;
        }
        return null;
    }

    @Override
    public <C extends Collection<JavaFileObject>> C list(String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse, C to) throws IOException {
        for (FileManager component : this.components) {
            component.list(packageName, kinds, recurse, to);
        }
        return to;
    }

    @Override
    public void clearCache() {
        for (FileManager component : this.components) {
            component.clearCache();
        }
    }
}

