/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.template.spi.juzu.dialect.gtmpl;

import groovy.lang.GString;
import groovy.lang.GroovyInterceptable;
import groovy.lang.GroovyObjectSupport;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import juzu.impl.template.spi.juzu.dialect.gtmpl.MessageKey;
import juzu.io.CharArray;
import juzu.template.TemplateRenderContext;
import org.codehaus.groovy.runtime.InvokerInvocationException;

public class GroovyPrinter
extends GroovyObjectSupport
implements GroovyInterceptable {
    final TemplateRenderContext renderContext;

    public GroovyPrinter(TemplateRenderContext renderContext) throws NullPointerException {
        if (renderContext == null) {
            throw new NullPointerException("No null render context accepted");
        }
        this.renderContext = renderContext;
    }

    public Object invokeMethod(String name, Object args) {
        Object[] array;
        if (args instanceof Object[] && (array = (Object[])args).length == 1) {
            try {
                if ("print".equals(name)) {
                    this.print(array[0]);
                    return null;
                }
                if ("println".equals(name)) {
                    this.println(array[0]);
                    return null;
                }
            }
            catch (IOException e) {
                throw new InvokerInvocationException((Throwable)e);
            }
        }
        return super.invokeMethod(name, args);
    }

    public final void println(Object o) throws IOException {
        this.print(o);
        this.println();
    }

    public final void println() throws IOException {
        this.renderContext.getPrinter().append('\n');
    }

    private Object format(Object o) {
        if (o instanceof Date) {
            Locale locale = this.renderContext.getLocale();
            if (locale != null) {
                DateFormat dateFormat = DateFormat.getDateInstance(2, locale);
                o = dateFormat.format((Date)o);
            }
        } else if (o instanceof MessageKey) {
            MessageKey key = (MessageKey)o;
            o = this.renderContext.resolveMessage(key);
        }
        return o;
    }

    private String toString(Object o) {
        Object f = this.format(o);
        if (f == null) {
            return "null";
        }
        if (f instanceof String) {
            return (String)f;
        }
        return o.toString();
    }

    public final void print(Object o) throws IOException {
        if (o instanceof CharArray) {
            this.renderContext.getPrinter().append((CharArray)o);
        } else if (o instanceof GString) {
            GString gs = (GString)o;
            Object[] values = gs.getValues();
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.format(values[i]);
            }
            this.renderContext.getPrinter().append(o.toString());
        } else {
            this.renderContext.getPrinter().append(this.toString(o));
        }
    }
}

