/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.saml;

import java.net.URI;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.parsers.saml.SAMLSubjectParser;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;

public abstract class SAMLRequestAbstractParser {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    protected String id;
    protected String version;
    protected XMLGregorianCalendar issueInstant;

    protected void parseRequiredAttributes(StartElement startElement) throws ParsingException {
        Attribute idAttr = startElement.getAttributeByName(new QName(JBossSAMLConstants.ID.get()));
        if (idAttr == null) {
            throw logger.parserRequiredAttribute("ID");
        }
        this.id = StaxParserUtil.getAttributeValue(idAttr);
        Attribute versionAttr = startElement.getAttributeByName(new QName(JBossSAMLConstants.VERSION.get()));
        if (versionAttr == null) {
            throw logger.parserRequiredAttribute("Version");
        }
        this.version = StaxParserUtil.getAttributeValue(versionAttr);
        Attribute issueInstantAttr = startElement.getAttributeByName(new QName(JBossSAMLConstants.ISSUE_INSTANT.get()));
        if (issueInstantAttr == null) {
            throw logger.parserRequiredAttribute("IssueInstant");
        }
        this.issueInstant = XMLTimeUtil.parse(StaxParserUtil.getAttributeValue(issueInstantAttr));
    }

    protected void parseBaseAttributes(StartElement startElement, RequestAbstractType request) throws ParsingException {
        Attribute consent;
        Attribute destinationAttr = startElement.getAttributeByName(new QName(JBossSAMLConstants.DESTINATION.get()));
        if (destinationAttr != null) {
            request.setDestination(URI.create(StaxParserUtil.getAttributeValue(destinationAttr)));
        }
        if ((consent = startElement.getAttributeByName(new QName(JBossSAMLConstants.CONSENT.get()))) != null) {
            request.setConsent(StaxParserUtil.getAttributeValue(consent));
        }
    }

    protected void parseCommonElements(StartElement startElement, XMLEventReader xmlEventReader, RequestAbstractType request) throws ParsingException {
        if (startElement == null) {
            throw logger.parserNullStartElement();
        }
        String elementName = StaxParserUtil.getStartElementName(startElement);
        if (JBossSAMLConstants.ISSUER.get().equals(elementName)) {
            startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
            NameIDType issuer = new NameIDType();
            issuer.setValue(StaxParserUtil.getElementText(xmlEventReader));
            request.setIssuer(issuer);
        } else if (JBossSAMLConstants.SIGNATURE.get().equals(elementName)) {
            request.setSignature(StaxParserUtil.getDOMElement(xmlEventReader));
        }
    }

    protected SubjectType getSubject(XMLEventReader xmlEventReader) throws ParsingException {
        SAMLSubjectParser subjectParser = new SAMLSubjectParser();
        return (SubjectType)subjectParser.parse(xmlEventReader);
    }
}

