/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.factories;

import java.net.URI;
import javax.xml.datatype.XMLGregorianCalendar;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.factories.SAMLAssertionFactory;
import org.picketlink.identity.federation.core.saml.v2.holders.IDPInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.holders.SPInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.EncryptedAssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectConfirmationDataType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectConfirmationType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusCodeType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusType;
import org.w3c.dom.Element;

public class JBossSAMLAuthnResponseFactory {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public static StatusType createStatusType(String statusCodeURI) {
        StatusCodeType sct = new StatusCodeType();
        sct.setValue(URI.create(statusCodeURI));
        StatusType statusType = new StatusType();
        statusType.setStatusCode(sct);
        return statusType;
    }

    public static ResponseType createResponseType(String ID, SPInfoHolder sp, IDPInfoHolder idp, IssuerInfoHolder issuerInfo) throws ConfigurationException {
        String responseDestinationURI = sp.getResponseDestinationURI();
        XMLGregorianCalendar issueInstant = XMLTimeUtil.getIssueInstant();
        String id = IDGenerator.create("ID_");
        SubjectType subjectType = new SubjectType();
        NameIDType nameIDType = new NameIDType();
        nameIDType.setFormat(URI.create(idp.getNameIDFormat()));
        nameIDType.setValue(idp.getNameIDFormatValue());
        SubjectType.STSubType subType = new SubjectType.STSubType();
        subType.addBaseID(nameIDType);
        subjectType.setSubType(subType);
        SubjectConfirmationType subjectConfirmation = new SubjectConfirmationType();
        subjectConfirmation.setMethod(idp.getSubjectConfirmationMethod());
        SubjectConfirmationDataType subjectConfirmationData = new SubjectConfirmationDataType();
        subjectConfirmationData.setInResponseTo(sp.getRequestID());
        subjectConfirmationData.setRecipient(responseDestinationURI);
        subjectConfirmationData.setNotOnOrAfter(issueInstant);
        subjectConfirmation.setSubjectConfirmationData(subjectConfirmationData);
        subjectType.addConfirmation(subjectConfirmation);
        AssertionType assertionType = SAMLAssertionFactory.createAssertion(id, nameIDType, issueInstant, null, subjectType, null);
        ResponseType responseType = JBossSAMLAuthnResponseFactory.createResponseType(ID, issuerInfo, assertionType);
        responseType.setInResponseTo(sp.getRequestID());
        responseType.setDestination(responseDestinationURI);
        return responseType;
    }

    public static ResponseType createResponseType(String ID, IssuerInfoHolder issuerInfo, AssertionType assertionType) throws ConfigurationException {
        XMLGregorianCalendar issueInstant = XMLTimeUtil.getIssueInstant();
        ResponseType responseType = new ResponseType(ID, issueInstant);
        NameIDType issuer = issuerInfo.getIssuer();
        responseType.setIssuer(issuer);
        String statusCode = issuerInfo.getStatusCode();
        if (statusCode == null) {
            throw logger.issuerInfoMissingStatusCodeError();
        }
        responseType.setStatus(JBossSAMLAuthnResponseFactory.createStatusType(statusCode));
        responseType.addAssertion(new ResponseType.RTChoiceType(assertionType));
        return responseType;
    }

    public static ResponseType createResponseType(String ID, IssuerInfoHolder issuerInfo, Element encryptedAssertion) throws ConfigurationException {
        ResponseType responseType = new ResponseType(ID, XMLTimeUtil.getIssueInstant());
        NameIDType issuer = issuerInfo.getIssuer();
        responseType.setIssuer(issuer);
        String statusCode = issuerInfo.getStatusCode();
        if (statusCode == null) {
            throw logger.issuerInfoMissingStatusCodeError();
        }
        responseType.setStatus(JBossSAMLAuthnResponseFactory.createStatusType(statusCode));
        responseType.addAssertion(new ResponseType.RTChoiceType(new EncryptedAssertionType(encryptedAssertion)));
        return responseType;
    }
}

