/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.jacc;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.security.jacc.PolicyContextException;
import org.jboss.logging.Logger;

public class ContextPolicy {
    private static Logger log = Logger.getLogger(ContextPolicy.class);
    private String contextID;
    private Permissions excludedPermissions = new Permissions();
    private Permissions uncheckedPermissions = new Permissions();
    private HashMap<String, Permissions> rolePermissions = new HashMap();
    private boolean trace;

    ContextPolicy(String contextID) {
        this.contextID = contextID;
        this.trace = log.isTraceEnabled();
    }

    Permissions getPermissions() {
        Permissions perms = new Permissions();
        Enumeration<Permission> eter = this.uncheckedPermissions.elements();
        while (eter.hasMoreElements()) {
            Permission p = eter.nextElement();
            perms.add(p);
        }
        for (Permissions rp : this.rolePermissions.values()) {
            eter = rp.elements();
            while (eter.hasMoreElements()) {
                Permission p = eter.nextElement();
                perms.add(p);
            }
        }
        return perms;
    }

    boolean implies(ProtectionDomain domain, Permission permission) {
        int n;
        boolean implied = false;
        if (this.excludedPermissions.implies(permission)) {
            if (this.trace) {
                log.trace((Object)("Denied: Matched excluded set, permission=" + permission));
            }
            return false;
        }
        if (this.uncheckedPermissions.implies(permission)) {
            if (this.trace) {
                log.trace((Object)("Allowed: Matched unchecked set, permission=" + permission));
            }
            return true;
        }
        Principal[] principals = domain.getPrincipals();
        int length = principals != null ? principals.length : 0;
        ArrayList<String> principalNames = new ArrayList<String>();
        for (n = 0; n < length; ++n) {
            Principal p = principals[n];
            if (p instanceof Group) {
                Group g = (Group)p;
                Enumeration iter = g.members();
                while (iter.hasMoreElements()) {
                    p = (Principal)iter.nextElement();
                    String name = p.getName();
                    principalNames.add(name);
                }
                continue;
            }
            String name = p.getName();
            principalNames.add(name);
        }
        if (principalNames.size() > 0) {
            if (this.trace) {
                log.trace((Object)("ProtectionDomain principals=" + principalNames));
            }
            for (n = 0; !implied && n < principalNames.size(); ++n) {
                String name = (String)principalNames.get(n);
                Permissions perms = this.rolePermissions.get(name);
                if (this.trace) {
                    log.trace((Object)("Checking role=" + name + " perms=" + perms));
                }
                if (perms == null) continue;
                implied = perms.implies(permission);
                if (!this.trace) continue;
                log.trace((Object)((implied ? "Allowed: " : "Denied: ") + " permission=" + permission));
            }
        } else if (this.trace) {
            log.trace((Object)("No principals found in domain: " + domain));
        }
        return implied;
    }

    void clear() {
        this.excludedPermissions = new Permissions();
        this.uncheckedPermissions = new Permissions();
        this.rolePermissions.clear();
    }

    void addToExcludedPolicy(Permission permission) throws PolicyContextException {
        this.excludedPermissions.add(permission);
    }

    void addToExcludedPolicy(PermissionCollection permissions) throws PolicyContextException {
        Enumeration<Permission> iter = permissions.elements();
        while (iter.hasMoreElements()) {
            Permission p = iter.nextElement();
            this.excludedPermissions.add(p);
        }
    }

    void addToRole(String roleName, Permission permission) throws PolicyContextException {
        Permissions perms = this.rolePermissions.get(roleName);
        if (perms == null) {
            perms = new Permissions();
            this.rolePermissions.put(roleName, perms);
        }
        perms.add(permission);
    }

    void addToRole(String roleName, PermissionCollection permissions) throws PolicyContextException {
        Permissions perms = this.rolePermissions.get(roleName);
        if (perms == null) {
            perms = new Permissions();
            this.rolePermissions.put(roleName, perms);
        }
        Enumeration<Permission> iter = permissions.elements();
        while (iter.hasMoreElements()) {
            Permission p = iter.nextElement();
            perms.add(p);
        }
    }

    void addToUncheckedPolicy(Permission permission) throws PolicyContextException {
        this.uncheckedPermissions.add(permission);
    }

    void addToUncheckedPolicy(PermissionCollection permissions) throws PolicyContextException {
        Enumeration<Permission> iter = permissions.elements();
        while (iter.hasMoreElements()) {
            Permission p = iter.nextElement();
            this.uncheckedPermissions.add(p);
        }
    }

    void commit() throws PolicyContextException {
    }

    void delete() throws PolicyContextException {
        this.clear();
    }

    String getContextID() throws PolicyContextException {
        return this.contextID;
    }

    void linkConfiguration(ContextPolicy link) throws PolicyContextException {
    }

    void removeExcludedPolicy() throws PolicyContextException {
        this.excludedPermissions = new Permissions();
    }

    void removeRole(String roleName) throws PolicyContextException {
        if ("*".equals(roleName) && !this.rolePermissions.containsKey("*")) {
            this.rolePermissions.clear();
        } else {
            this.rolePermissions.remove(roleName);
        }
    }

    void removeUncheckedPolicy() throws PolicyContextException {
        this.uncheckedPermissions = new Permissions();
    }

    Permissions getPermissionsForRole(String role) {
        return this.rolePermissions.get(role);
    }

    public String toString() {
        Permission p;
        StringBuffer tmp = new StringBuffer("<ContextPolicy contextID='");
        tmp.append(this.contextID);
        tmp.append("'>\n");
        tmp.append("\t<ExcludedPermissions>\n");
        Enumeration<Permission> iter = this.excludedPermissions.elements();
        while (iter.hasMoreElements()) {
            p = iter.nextElement();
            tmp.append("<Permission type='");
            tmp.append(p.getClass());
            tmp.append("' name='");
            tmp.append(p.getName());
            tmp.append("' actions='");
            tmp.append(p.getActions());
            tmp.append("' />\n");
        }
        tmp.append("\t</ExcludedPermissions>\n");
        tmp.append("\t<UncheckedPermissions>\n");
        iter = this.uncheckedPermissions.elements();
        while (iter.hasMoreElements()) {
            p = iter.nextElement();
            tmp.append("<Permission type='");
            tmp.append(p.getClass());
            tmp.append(" name='");
            tmp.append(p.getName());
            tmp.append("' actions='");
            tmp.append(p.getActions());
            tmp.append("' />\n");
        }
        tmp.append("\t</UncheckedPermissions>\n");
        tmp.append("\t<RolePermssions>\n");
        for (String role : this.rolePermissions.keySet()) {
            Permissions perms = this.rolePermissions.get(role);
            iter = perms.elements();
            tmp.append("\t\t<Role name='" + role + "'>\n");
            while (iter.hasMoreElements()) {
                Permission p2 = iter.nextElement();
                tmp.append("<Permission type='");
                tmp.append(p2.getClass());
                tmp.append(" name='");
                tmp.append(p2.getName());
                tmp.append("' actions='");
                tmp.append(p2.getActions());
                tmp.append("' />\n");
            }
            tmp.append("\t\t</Role>\n");
        }
        tmp.append("\t</RolePermssions>");
        tmp.append("</ContextPolicy>\n");
        return tmp.toString();
    }
}

