/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.xml;

import org.apache.tika.metadata.Metadata;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class MetadataHandler
extends DefaultHandler {
    private final Metadata metadata;
    private final String name;
    private final StringBuilder buffer = new StringBuilder();

    public MetadataHandler(Metadata metadata, String name) {
        this.metadata = metadata;
        this.name = name;
    }

    public void addMetadata(String value) {
        if (value.length() > 0) {
            String previous = this.metadata.get(this.name);
            if (previous != null && previous.length() > 0) {
                value = previous + ", " + value;
            }
            this.metadata.set(this.name, value);
        }
    }

    public void endElement(String uri, String localName, String name) {
        this.addMetadata(this.buffer.toString());
        this.buffer.setLength(0);
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            this.addMetadata(attributes.getValue(i));
        }
    }

    public void characters(char[] ch, int start, int length) {
        this.buffer.append(ch, start, length);
    }
}

