/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.web.application.RequestFailure;
import org.exoplatform.web.login.LogoutControl;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;

public class UserProfileLifecycle
implements ApplicationLifecycle<WebuiRequestContext> {
    public static final String USER_PROFILE_ATTRIBUTE_NAME = "PortalUserProfile";
    private static final ThreadLocal<UserProfile> currentUserProfile = new ThreadLocal();

    public void onInit(Application app) {
    }

    public void onStartRequest(Application app, WebuiRequestContext context) throws Exception {
        String user = context.getRemoteUser();
        UserProfile userProfile = null;
        if (user != null) {
            ExoContainer exoContainer = app.getApplicationServiceContainer();
            if (exoContainer != null) {
                OrganizationService organizationService = (OrganizationService)exoContainer.getComponentInstanceOfType(OrganizationService.class);
                userProfile = organizationService.getUserProfileHandler().findUserProfileByName(user);
            }
            if (userProfile == null) {
                LogoutControl.wantLogout();
                PortalRequestContext prContext = (PortalRequestContext)context;
                NodeURL createURL = (NodeURL)prContext.createURL(NodeURL.TYPE);
                createURL.setResource(new NavigationResource(SiteType.PORTAL, prContext.getPortalOwner(), null));
                prContext.sendRedirect(createURL.toString());
            }
        }
        currentUserProfile.set(userProfile);
        context.setAttribute(USER_PROFILE_ATTRIBUTE_NAME, userProfile);
    }

    public void onFailRequest(Application app, WebuiRequestContext context, RequestFailure failureType) {
    }

    public void onEndRequest(Application app, WebuiRequestContext context) throws Exception {
        currentUserProfile.remove();
    }

    public void onDestroy(Application app) {
    }
}

