/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.InitParams;
import org.exoplatform.webui.config.Param;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ParamConfig;
import org.exoplatform.webui.core.UIDropDownControl;
import org.exoplatform.webui.core.model.SelectItemCategory;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormInputItemSelector;

@ComponentConfig(template="system:/groovy/portal/webui/page/UIPageTemplateOptions.gtmpl", initParams={@ParamConfig(name="PageLayout", value="system:/WEB-INF/conf/uiconf/portal/webui/page/PageConfigOptions.groovy")})
public class UIPageTemplateOptions
extends UIFormInputItemSelector {
    private SelectItemOption<?> selectedItemOption_ = null;

    public UIPageTemplateOptions(InitParams initParams) throws Exception {
        super("UIPageTemplateOptions", null);
        if (initParams == null) {
            return;
        }
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Param param = initParams.getParam("PageLayout");
        this.categories_ = (List)param.getFreshObject(context);
        this.selectedItemOption_ = this.getDefaultItemOption();
        ArrayList<SelectItemOption> itemOptions = new ArrayList<SelectItemOption>();
        for (SelectItemCategory itemCategory : this.categories_) {
            itemOptions.add(new SelectItemOption((Object)itemCategory.getName()));
        }
        UIDropDownControl uiItemSelector = (UIDropDownControl)this.addChild(UIDropDownControl.class, null, "UIDropDownPageTemp");
        uiItemSelector.setOptions(itemOptions);
        uiItemSelector.setAction("eXo.webui.UIPageTemplateOptions.selectPageLayout");
    }

    public SelectItemOption<?> getDefaultItemOption() {
        SelectItemCategory category = this.getSelectedCategory();
        if (category == null) {
            return null;
        }
        SelectItemOption itemOption = category.getSelectedItemOption();
        if (itemOption == null) {
            return null;
        }
        return itemOption;
    }

    public void setSelectOptionItem(String value) {
        for (SelectItemCategory itemCategory : this.categories_) {
            for (SelectItemOption itemOption : itemCategory.getSelectItemOptions()) {
                if (!itemOption.getLabel().equals(value)) continue;
                this.selectedItemOption_ = itemOption;
                for (SelectItemOption item : itemCategory.getSelectItemOptions()) {
                    item.setSelected(false);
                }
                itemOption.setSelected(true);
                return;
            }
        }
        this.selectedItemOption_ = null;
    }

    public SelectItemOption getSelectedItemOption() {
        return this.selectedItemOption_;
    }

    public void decode(Object input, WebuiRequestContext context) {
        if (input == null || String.valueOf(input).length() < 1) {
            return;
        }
        this.setSelectOptionItem((String)input);
    }

    public void setSelectedOption(SelectItemOption selectedItemOption) {
        this.selectedItemOption_ = selectedItemOption;
    }

    public Page createPageFromSelectedOption(String ownerType, String ownerId) throws Exception {
        if (this.selectedItemOption_ == null) {
            this.selectedItemOption_ = this.getDefaultItemOption();
        }
        if (this.selectedItemOption_ == null) {
            return null;
        }
        Object temp = this.selectedItemOption_.getValue();
        if (temp == null) {
            return null;
        }
        UserPortalConfigService configService = (UserPortalConfigService)this.getApplicationComponent(UserPortalConfigService.class);
        return configService.createPageTemplate(temp.toString(), ownerType, ownerId);
    }
}

