/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractContainerBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class MetaBox
extends AbstractContainerBox {
    private int version = 0;
    private int flags = 0;
    public static final String TYPE = "meta";

    public MetaBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public long getContentSize() {
        if (this.isMp4Box()) {
            return 4L + super.getContentSize();
        }
        return super.getContentSize();
    }

    public long getNumOfBytesToFirstChild() {
        if (this.isMp4Box()) {
            return 12L;
        }
        return 8L;
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        if (this.isMp4Box()) {
            os.writeUInt8(this.version);
            os.writeUInt24(this.flags);
        }
        super.getContent(os);
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        long pos = in.position();
        in.skip(4L);
        if ("hdlr".equals(IsoFile.bytesToFourCC(in.read(4)))) {
            in.position(pos);
            this.version = -1;
            this.flags = -1;
        } else {
            in.position(pos);
            this.version = in.readUInt8();
            this.flags = in.readUInt24();
        }
        super.parse(in, size, boxParser, lastMovieFragmentBox);
    }

    public boolean isMp4Box() {
        return this.version != -1 && this.flags != -1;
    }

    public void setMp4Box(boolean mp4) {
        if (mp4) {
            this.version = 0;
            this.flags = 0;
        } else {
            this.version = -1;
            this.flags = -1;
        }
    }
}

