/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public final class OmaDrmAccessUnitFormatBox
extends AbstractFullBox {
    public static final String TYPE = "odaf";
    private boolean selectiveEncryption;
    private byte allBits;
    private int keyIndicatorLength;
    private int initVectorLength;

    protected long getContentSize() {
        return 3L;
    }

    public OmaDrmAccessUnitFormatBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public boolean isSelectiveEncryption() {
        return this.selectiveEncryption;
    }

    public int getKeyIndicatorLength() {
        return this.keyIndicatorLength;
    }

    public int getInitVectorLength() {
        return this.initVectorLength;
    }

    public void setInitVectorLength(int initVectorLength) {
        this.initVectorLength = initVectorLength;
    }

    public void setKeyIndicatorLength(int keyIndicatorLength) {
        this.keyIndicatorLength = keyIndicatorLength;
    }

    public void setAllBits(byte allBits) {
        this.allBits = allBits;
        this.selectiveEncryption = (allBits & 0x80) == 128;
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.writeUInt8(this.allBits);
        isos.writeUInt8(this.keyIndicatorLength);
        isos.writeUInt8(this.initVectorLength);
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.allBits = (byte)in.readUInt8();
        this.selectiveEncryption = (this.allBits & 0x80) == 128;
        this.keyIndicatorLength = in.readUInt8();
        this.initVectorLength = in.readUInt8();
    }
}

