/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.DataCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.eviction.BaseEvictionAlgorithm;
import org.jboss.cache.eviction.EvictionEvent;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.ExpirationAlgorithmConfig;
import org.jboss.cache.eviction.NodeEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpirationAlgorithm
extends BaseEvictionAlgorithm {
    private static final Log log = LogFactory.getLog(ExpirationAlgorithm.class);
    private static final boolean trace = log.isTraceEnabled();
    private ExpirationAlgorithmConfig config;
    private SortedSet<ExpirationEntry> set = new TreeSet<ExpirationEntry>();

    private void addEvictionEntry(EvictionEvent node) {
        Fqn fqn = node.getFqn();
        this.addEvictionEntry(fqn, node.getCommand(), node.getTransaction());
    }

    private void addEvictionEntry(Fqn fqn, DataCommand command, Transaction tx) {
        Long l = this.getExpiration(fqn);
        if (l == null) {
            if (command != null) {
                l = this.getExpirationFromCommand(command);
            }
            if (l == null) {
                return;
            }
        }
        if (l == -1L) {
            if (this.config.isWarnNoExpirationKey() && log.isWarnEnabled()) {
                log.warn((Object)("No expiration key '" + this.config.getExpirationKeyName() + "' for Node: " + fqn));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("No expiration key for Node: " + fqn));
            }
        } else {
            this.setExpiration(fqn, l, tx);
        }
    }

    private Long getExpirationFromCommand(DataCommand command) {
        PutDataMapCommand putDataCommand;
        Object expiration;
        if (command instanceof PutKeyValueCommand) {
            PutKeyValueCommand putKeyCommand = (PutKeyValueCommand)command;
            if (putKeyCommand.getKey().equals(this.config.getExpirationKeyName())) {
                return (Long)putKeyCommand.getValue();
            }
        } else if (command instanceof PutDataMapCommand && (expiration = (putDataCommand = (PutDataMapCommand)command).getData().get(this.config.getExpirationKeyName())) != null) {
            return (Long)expiration;
        }
        return null;
    }

    private void setExpiration(Fqn fqn, Long l, Transaction tx) {
        ExpirationEntry ee = new ExpirationEntry(fqn, l, tx);
        if (trace) {
            log.trace((Object)("adding eviction entry: " + ee));
        }
        this.set.add(ee);
    }

    private Long getExpiration(Fqn fqn) {
        NodeSPI n = this.cache.peek(fqn, false);
        if (n == null) {
            return null;
        }
        Long expiration = (Long)n.getDirect(this.config.getExpirationKeyName());
        if (expiration == null) {
            return -1L;
        }
        return expiration;
    }

    @Override
    protected void processQueues(BlockingQueue<EvictionEvent> queue) throws EvictionException {
        EvictionEvent node;
        int count = 0;
        block6: while ((node = this.getNextInQueue(queue)) != null) {
            ++count;
            switch (node.getEventType()) {
                case ADD_NODE_EVENT: 
                case ADD_ELEMENT_EVENT: {
                    this.addEvictionEntry(node);
                    continue block6;
                }
                case REMOVE_ELEMENT_EVENT: 
                case REMOVE_NODE_EVENT: 
                case UNMARK_USE_EVENT: {
                    continue block6;
                }
                case VISIT_NODE_EVENT: {
                    continue block6;
                }
                case MARK_IN_USE_EVENT: {
                    this.markInUse(node);
                    continue block6;
                }
            }
            throw new RuntimeException("Illegal Eviction Event type " + (Object)((Object)node.getEventType()));
        }
        if (trace) {
            log.trace((Object)("processed " + count + " node events in region: " + this.regionFqn));
        }
    }

    private void markInUse(EvictionEvent node) {
        long expiration = node.getInUseTimeout() + System.currentTimeMillis();
        this.setExpiration(node.getFqn(), expiration, node.getTransaction());
    }

    @Override
    protected void prune() throws EvictionException {
        if (this.set.isEmpty()) {
            return;
        }
        long now = System.currentTimeMillis();
        int max = this.config.getMaxNodes();
        Iterator i = this.set.iterator();
        while (i.hasNext()) {
            Long ce;
            ExpirationEntry ee = (ExpirationEntry)i.next();
            if (trace) {
                log.trace((Object)("attempt to prune: " + ee));
            }
            if ((ce = this.getExpiration(ee.getFqn())) == null) {
                if (ee.getTransaction() != null && this.isTransactionActive(ee.getTransaction())) {
                    if (!trace) continue;
                    log.trace((Object)("transaction active, keep eviction entry: " + ee));
                    continue;
                }
                i.remove();
                continue;
            }
            if (ce == -1L || ce > ee.getExpiration()) {
                i.remove();
                continue;
            }
            if (ee.getExpiration() >= now && (max == -1 || this.set.size() <= max)) break;
            i.remove();
            this.evictCacheNode(ee.getFqn());
        }
        if (max != -1 && this.set.size() > max) {
            log.warn((Object)("Unable to remove nodes to reduce region size below " + this.config.getMaxNodes() + ".  " + "Set expiration for nodes in this region"));
        }
    }

    private boolean isTransactionActive(Transaction transaction) {
        try {
            switch (transaction.getStatus()) {
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return false;
                }
            }
            return true;
        }
        catch (SystemException e) {
            return false;
        }
    }

    @Override
    public void resetEvictionQueue() {
        for (ExpirationEntry ee : this.set) {
            this.addEvictionEntry(ee.getFqn(), null, null);
        }
    }

    @Override
    protected EvictionQueue setupEvictionQueue() throws EvictionException {
        this.config = (ExpirationAlgorithmConfig)this.evictionAlgorithmConfig;
        return new DummyEvictionQueue();
    }

    @Override
    protected boolean shouldEvictNode(NodeEntry ne) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canIgnoreEvent(EvictionEvent.Type eventType) {
        return eventType == EvictionEvent.Type.VISIT_NODE_EVENT;
    }

    @Override
    public Class<? extends EvictionAlgorithmConfig> getConfigurationClass() {
        return ExpirationAlgorithmConfig.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DummyEvictionQueue
    implements EvictionQueue {
        DummyEvictionQueue() {
        }

        @Override
        public void addNodeEntry(NodeEntry entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            ExpirationAlgorithm.this.set.clear();
        }

        @Override
        public boolean containsNodeEntry(NodeEntry entry) {
            return false;
        }

        @Override
        public NodeEntry getFirstNodeEntry() {
            return null;
        }

        @Override
        public NodeEntry getNodeEntry(Fqn fqn) {
            return null;
        }

        @Override
        public NodeEntry getNodeEntry(String fqn) {
            return null;
        }

        @Override
        public int getNumberOfElements() {
            return ExpirationAlgorithm.this.set.size();
        }

        @Override
        public int getNumberOfNodes() {
            return ExpirationAlgorithm.this.set.size();
        }

        @Override
        public Iterator<NodeEntry> iterator() {
            return null;
        }

        @Override
        public void modifyElementCount(int difference) {
        }

        @Override
        public void removeNodeEntry(NodeEntry entry) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ExpirationEntry
    implements Comparable<ExpirationEntry> {
        private long expiration;
        private Fqn fqn;
        private Transaction transaction;

        public ExpirationEntry(Fqn fqn) {
            this.fqn = fqn;
        }

        public ExpirationEntry(Fqn fqn, long expiration, Transaction transaction) {
            this.fqn = fqn;
            this.expiration = expiration;
            this.transaction = transaction;
        }

        @Override
        public int compareTo(ExpirationEntry ee) {
            long n = this.expiration - ee.expiration;
            if (n < 0L) {
                return -1;
            }
            if (n > 0L) {
                return 1;
            }
            return this.fqn.compareTo(ee.fqn);
        }

        public long getExpiration() {
            return this.expiration;
        }

        public Fqn getFqn() {
            return this.fqn;
        }

        public Transaction getTransaction() {
            return this.transaction;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ExpirationEntry)) {
                return false;
            }
            ExpirationEntry ee = (ExpirationEntry)o;
            return this.expiration == ee.expiration && this.fqn.equals(ee.fqn);
        }

        public int hashCode() {
            return (int)this.expiration ^ this.fqn.hashCode();
        }

        public String toString() {
            long now = System.currentTimeMillis();
            long ttl = this.expiration - now;
            String sttl = ttl > 60000L ? ttl / 60000L + "min" : (ttl > 1000L ? ttl / 1000L + "s" : ttl + "ms");
            return "EE fqn=" + this.fqn + " ttl=" + sttl;
        }
    }
}

