/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.conversion;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDelegator {
    public static final String NULL = "<NULL sentinel>";
    private static final Map<String, Object> EMPTY_FIELDS = ImmutableMap.of();
    public static final ImmutableSet<Class<?>> PRIMITIVE_TYPE_CLASSES = ImmutableSet.of(String.class, Integer.class, Long.class, Boolean.class, Uri.class);
    private final Map<Class<?>, Class<?>> delegatedClasses;
    private final Map<Enum<?>, Enum<?>> enumConvertionMap;

    public static Object nullable(Object o) {
        return o != null ? o : NULL;
    }

    public BeanDelegator() {
        this((Map<Class<?>, Class<?>>)ImmutableMap.of(), (Map<Enum<?>, Enum<?>>)ImmutableMap.of());
    }

    public BeanDelegator(Map<Class<?>, Class<?>> delegatedClasses, Map<Enum<?>, Enum<?>> enumConvertionMap) {
        this.delegatedClasses = delegatedClasses;
        this.enumConvertionMap = enumConvertionMap;
    }

    public Object createDelegator(Object source) {
        if (source == null || this.delegatedClasses == null) {
            return null;
        }
        if (source instanceof Enum && this.delegatedClasses.containsKey(source.getClass())) {
            return this.convertEnum((Enum)source);
        }
        if (source instanceof Map) {
            Map mapSource = (Map)source;
            if (!mapSource.isEmpty() && this.delegatedClasses.containsKey(mapSource.values().iterator().next().getClass())) {
                ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
                for (Map.Entry entry : mapSource.entrySet()) {
                    mapBuilder.put(entry.getKey(), this.createDelegator(entry.getValue()));
                }
                return mapBuilder.build();
            }
            return source;
        }
        if (source instanceof List) {
            List listSource = (List)source;
            if (!listSource.isEmpty() && this.delegatedClasses.containsKey(listSource.get(0).getClass())) {
                ImmutableList.Builder listBuilder = ImmutableList.builder();
                for (Object entry : listSource) {
                    listBuilder.add(this.createDelegator(entry));
                }
                return listBuilder.build();
            }
            return source;
        }
        if (this.delegatedClasses.containsKey(source.getClass())) {
            Class<?> apiInterface = this.delegatedClasses.get(source.getClass());
            return this.createDelegator(source, apiInterface);
        }
        return source;
    }

    public <T> T createDelegator(Object source, Class<T> apiInterface) {
        return this.createDelegator(source, apiInterface, EMPTY_FIELDS);
    }

    public <T> T createDelegator(Object source, Class<T> apiInterface, Map<String, Object> extraFields) {
        return (T)Proxy.newProxyInstance(apiInterface.getClassLoader(), new Class[]{apiInterface}, (InvocationHandler)new DelegateInvocationHandler(source, extraFields));
    }

    public Enum<?> convertEnum(Enum<?> value) {
        if (this.enumConvertionMap.containsKey(value)) {
            return this.enumConvertionMap.get(value);
        }
        throw new UnsupportedOperationException("Unknown enum value " + value.toString());
    }

    public void validate() throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        for (Map.Entry<Class<?>, Class<?>> entry : this.delegatedClasses.entrySet()) {
            if (entry.getKey().isEnum()) continue;
            this.validate(entry.getKey(), entry.getValue());
        }
    }

    public void validate(Class<?> dataClass, Class<?> interfaceClass) throws SecurityException, NoSuchMethodException, NoSuchFieldException {
        for (Method method : interfaceClass.getMethods()) {
            Method dataMethod = dataClass.getMethod(method.getName(), method.getParameterTypes());
            if (dataMethod == null) {
                throw new NoSuchMethodException("Method " + method.getName() + " is not implemented by " + dataClass.getName());
            }
            if (this.validateTypes(dataMethod.getGenericReturnType(), method.getGenericReturnType())) continue;
            throw new NoSuchMethodException("Method " + method.getName() + " has wrong return type by " + dataClass.getName());
        }
    }

    private boolean validateTypes(Type dataType, Type interfaceType) throws NoSuchFieldException {
        if (dataType instanceof ParameterizedType) {
            ParameterizedType dataParamType = (ParameterizedType)dataType;
            ParameterizedType interfaceParamType = (ParameterizedType)interfaceType;
            if (List.class.isAssignableFrom((Class)dataParamType.getRawType()) && List.class.isAssignableFrom((Class)interfaceParamType.getRawType())) {
                dataType = dataParamType.getActualTypeArguments()[0];
                interfaceType = interfaceParamType.getActualTypeArguments()[0];
                return this.validateTypes(dataType, interfaceType);
            }
            if (Map.class.isAssignableFrom((Class)dataParamType.getRawType()) && Map.class.isAssignableFrom((Class)interfaceParamType.getRawType())) {
                Type interfaceKeyType;
                Type dataKeyType = dataParamType.getActualTypeArguments()[0];
                if (dataKeyType != (interfaceKeyType = interfaceParamType.getActualTypeArguments()[0]) || !PRIMITIVE_TYPE_CLASSES.contains((Object)dataKeyType)) {
                    return false;
                }
                dataType = dataParamType.getActualTypeArguments()[1];
                interfaceType = interfaceParamType.getActualTypeArguments()[1];
                return this.validateTypes(dataType, interfaceType);
            }
            return false;
        }
        if (dataType == interfaceType) {
            return PRIMITIVE_TYPE_CLASSES.contains((Object)dataType) || ((Class)dataType).isPrimitive();
        }
        Class dataClass = (Class)dataType;
        if (dataClass.isEnum()) {
            for (Object f : dataClass.getEnumConstants()) {
                if (this.enumConvertionMap.containsKey(f) && this.enumConvertionMap.get(f).getClass() == interfaceType) continue;
                throw new NoSuchFieldException("Enum " + dataClass.getName() + " don't have mapping for value " + f.toString());
            }
        }
        return this.delegatedClasses.get(dataType) == interfaceType;
    }

    public static Map<Enum<?>, Enum<?>> createDefaultEnumMap(Class<? extends Enum<?>> sourceEnum, Class<? extends Enum<?>> targetEnum) {
        HashMap values2Map = Maps.newHashMap();
        for (Enum<?> val2 : targetEnum.getEnumConstants()) {
            values2Map.put(val2.toString(), val2);
        }
        Enum<?>[] values1 = sourceEnum.getEnumConstants();
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Enum<?> val1 : sourceEnum.getEnumConstants()) {
            if (!values2Map.containsKey(val1.toString())) {
                throw new RuntimeException("Missing enum value " + val1.toString() + " for enum " + targetEnum.getName());
            }
            mapBuilder.put(val1, values2Map.get(val1.toString()));
        }
        return mapBuilder.build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DelegateInvocationHandler
    implements InvocationHandler {
        private final Object source;
        private final Map<String, Object> extraFields;

        public DelegateInvocationHandler(Object source) {
            this(source, null);
        }

        public DelegateInvocationHandler(Object source, Map<String, Object> extraFields) {
            Preconditions.checkNotNull((Object)source);
            this.source = source;
            this.extraFields = extraFields == null ? EMPTY_FIELDS : extraFields;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            String field;
            Class<?> sourceClass = this.source.getClass();
            if (!this.extraFields.isEmpty() && method.getName().startsWith("get") && this.extraFields.containsKey(field = method.getName().substring(3).toLowerCase())) {
                Object data = this.extraFields.get(field);
                return data == BeanDelegator.NULL ? null : data;
            }
            try {
                Method sourceMethod = sourceClass.getMethod(method.getName(), method.getParameterTypes());
                Object result = sourceMethod.invoke(this.source, args);
                return BeanDelegator.this.createDelegator(result);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
            throw new UnsupportedOperationException("Unsupported function: " + method.getName());
        }
    }
}

