/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Transaction;
import org.infinispan.CacheException;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.AbstractCacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class LocalTransaction
extends AbstractCacheTransaction {
    private static final Log log = LogFactory.getLog(LocalTransaction.class);
    private static final boolean trace = log.isTraceEnabled();
    private Set<Address> remoteLockedNodes;
    protected Set<Object> readKeys = null;
    private volatile boolean isMarkedForRollback;
    private final Transaction transaction;
    private final boolean implicitTransaction;

    public LocalTransaction(Transaction transaction, GlobalTransaction tx, boolean implicitTransaction, int viewId) {
        super(tx, viewId);
        this.transaction = transaction;
        this.implicitTransaction = implicitTransaction;
    }

    public void addModification(WriteCommand mod) {
        if (trace) {
            log.tracef("Adding modification %s. Mod list is %s", mod, this.modifications);
        }
        if (this.modifications == null) {
            this.modifications = new LinkedList();
        }
        this.modifications.add(mod);
    }

    public void locksAcquired(Collection<Address> nodes) {
        log.tracef("Adding remote locks on %s. Remote locks are %s", nodes, this.remoteLockedNodes);
        if (this.remoteLockedNodes == null) {
            this.remoteLockedNodes = new HashSet<Address>(nodes);
        } else {
            this.remoteLockedNodes.addAll(nodes);
        }
    }

    public Collection<Address> getRemoteLocksAcquired() {
        if (this.remoteLockedNodes == null) {
            return Collections.emptySet();
        }
        return this.remoteLockedNodes;
    }

    public void clearRemoteLocksAcquired() {
        if (this.remoteLockedNodes != null) {
            this.remoteLockedNodes.clear();
        }
    }

    public void markForRollback(boolean markForRollback) {
        this.isMarkedForRollback = markForRollback;
    }

    public final boolean isMarkedForRollback() {
        return this.isMarkedForRollback;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    @Override
    public Map<Object, CacheEntry> getLookedUpEntries() {
        return this.lookedUpEntries == null ? Collections.emptyMap() : this.lookedUpEntries;
    }

    public boolean isImplicitTransaction() {
        return this.implicitTransaction;
    }

    @Override
    public void putLookedUpEntry(Object key, CacheEntry e) {
        if (this.isMarkedForRollback()) {
            throw new CacheException("This transaction is marked for rollback and cannot acquire locks!");
        }
        if (this.lookedUpEntries == null) {
            this.lookedUpEntries = new HashMap(4);
        }
        this.lookedUpEntries.put(key, e);
    }

    @Override
    public void putLookedUpEntries(Map<Object, CacheEntry> entries) {
        if (this.isMarkedForRollback()) {
            throw new CacheException("This transaction is marked for rollback and cannot acquire locks!");
        }
        if (this.lookedUpEntries == null) {
            this.lookedUpEntries = new HashMap<Object, CacheEntry>(entries);
        } else {
            this.lookedUpEntries.putAll(entries);
        }
    }

    public boolean isReadOnly() {
        return !(this.modifications != null && !this.modifications.isEmpty() || this.lookedUpEntries != null && !this.lookedUpEntries.isEmpty());
    }

    public abstract boolean isEnlisted();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalTransaction that = (LocalTransaction)o;
        return this.tx.getId() == that.tx.getId();
    }

    public int hashCode() {
        long id = this.tx.getId();
        return (int)(id ^ id >>> 32);
    }

    public String toString() {
        return "LocalTransaction{remoteLockedNodes=" + this.remoteLockedNodes + ", isMarkedForRollback=" + this.isMarkedForRollback + ", transaction=" + this.transaction + ", lockedKeys=" + this.lockedKeys + ", backupKeyLocks=" + this.backupKeyLocks + ", viewId=" + this.viewId + "} " + super.toString();
    }

    public void setModifications(List<WriteCommand> modifications) {
        this.modifications = modifications;
    }

    @Override
    public void addReadKey(Object key) {
        if (this.readKeys == null) {
            this.readKeys = new HashSet<Object>(2);
        }
        this.readKeys.add(key);
    }

    @Override
    public boolean keyRead(Object key) {
        return this.readKeys != null && this.readKeys.contains(key);
    }
}

