/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ActivityTypeUtils {
    private static final Log LOG = ExoLogger.getLogger(ActivityTypeUtils.class);
    public static String EXO_ACTIVITY_INFO = "exo:activityInfo";
    public static String EXO_ACTIVITY_ID = "exo:activityId";

    public static void attachActivityId(Node ownerNode, String activityId) {
        try {
            if (!ownerNode.isNodeType(EXO_ACTIVITY_INFO) && ownerNode.canAddMixin(EXO_ACTIVITY_INFO)) {
                ownerNode.addMixin(EXO_ACTIVITY_INFO);
            }
            ownerNode.setProperty(EXO_ACTIVITY_ID, activityId);
        }
        catch (RepositoryException e) {
            LOG.error((Object)("Failed to attach activityId " + activityId), (Throwable)e);
        }
    }

    public static String getActivityId(Node ownerNode) {
        try {
            if (ownerNode.isNodeType(EXO_ACTIVITY_INFO)) {
                return ownerNode.getProperty(EXO_ACTIVITY_ID).getString();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to get value of exo:activityId.", (Throwable)e);
        }
        return null;
    }

    public static void removeAttchAtivityId(Node ownerNode) {
        ActivityTypeUtils.attachActivityId(ownerNode, "");
    }
}

