/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.LiveVariablesAnalysis;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.rhino.Node;

class DeadAssignmentsElimination
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass,
NodeTraversal.ScopedCallback {
    private final AbstractCompiler compiler;
    private LiveVariablesAnalysis liveness;
    private static final Predicate<Node> matchRemovableAssigns = new Predicate<Node>(){

        public boolean apply(Node n) {
            return NodeUtil.isAssignmentOp(n) && n.getFirstChild().isName() || n.isInc() || n.isDec();
        }
    };

    public DeadAssignmentsElimination(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkNotNull((Object)externs);
        Preconditions.checkNotNull((Object)root);
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void enterScope(NodeTraversal t) {
        Scope scope = t.getScope();
        if (scope.isGlobal()) {
            return;
        }
        if (100 < t.getScope().getVarCount()) {
            return;
        }
        Node fnBlock = t.getScopeRoot().getLastChild();
        if (NodeUtil.containsFunction(fnBlock)) {
            return;
        }
        if (!NodeUtil.has(fnBlock, matchRemovableAssigns, (Predicate<Node>)Predicates.alwaysTrue())) {
            return;
        }
        ControlFlowGraph<Node> cfg = t.getControlFlowGraph();
        this.liveness = new LiveVariablesAnalysis(cfg, scope, this.compiler);
        this.liveness.analyze();
        this.tryRemoveDeadAssignments(t, cfg);
    }

    @Override
    public void exitScope(NodeTraversal t) {
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
    }

    private void tryRemoveDeadAssignments(NodeTraversal t, ControlFlowGraph<Node> cfg) {
        Iterable nodes = cfg.getDirectedGraphNodes();
        block5: for (DiGraph.DiGraphNode cfgNode : nodes) {
            DataFlowAnalysis.FlowState state = (DataFlowAnalysis.FlowState)cfgNode.getAnnotation();
            Node n = (Node)cfgNode.getValue();
            if (n == null) continue;
            switch (n.getType()) {
                case 108: 
                case 113: 
                case 114: {
                    this.tryRemoveAssignment(t, NodeUtil.getConditionExpression(n), state);
                    continue block5;
                }
                case 115: {
                    if (NodeUtil.isForIn(n)) continue block5;
                    this.tryRemoveAssignment(t, NodeUtil.getConditionExpression(n), state);
                    continue block5;
                }
                case 4: 
                case 110: 
                case 111: {
                    if (!n.hasChildren()) continue block5;
                    this.tryRemoveAssignment(t, n.getFirstChild(), state);
                    continue block5;
                }
            }
            this.tryRemoveAssignment(t, n, state);
        }
    }

    private void tryRemoveAssignment(NodeTraversal t, Node n, DataFlowAnalysis.FlowState<LiveVariablesAnalysis.LiveVariableLattice> state) {
        this.tryRemoveAssignment(t, n, n, state);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void tryRemoveAssignment(NodeTraversal t, Node n, Node exprRoot, DataFlowAnalysis.FlowState<LiveVariablesAnalysis.LiveVariableLattice> state) {
        Node parent = n.getParent();
        if (NodeUtil.isAssignmentOp(n) || n.isInc() || n.isDec()) {
            Node lhs = n.getFirstChild();
            Node rhs = lhs.getNext();
            if (rhs != null) {
                this.tryRemoveAssignment(t, rhs, exprRoot, state);
                rhs = lhs.getNext();
            }
            Scope scope = t.getScope();
            if (!lhs.isName()) {
                return;
            }
            String name = lhs.getString();
            if (!scope.isDeclared(name, false)) {
                return;
            }
            Scope.Var var = scope.getVar(name);
            if (this.liveness.getEscapedLocals().contains(var)) {
                return;
            }
            if (rhs != null && rhs.isName() && rhs.getString().equals(var.name) && n.isAssign()) {
                n.removeChild(rhs);
                n.getParent().replaceChild(n, rhs);
                this.compiler.reportCodeChange();
                return;
            }
            if (state.getOut().isLive(var)) {
                return;
            }
            if (state.getIn().isLive(var) && this.isVariableStillLiveWithinExpression(n, exprRoot, var.name)) {
                return;
            }
            if (n.isAssign()) {
                n.removeChild(rhs);
                n.getParent().replaceChild(n, rhs);
            } else if (NodeUtil.isAssignmentOp(n)) {
                n.removeChild(rhs);
                n.removeChild(lhs);
                Node op = new Node(NodeUtil.getOpFromAssignmentOp(n), lhs, rhs);
                parent.replaceChild(n, op);
            } else if (n.isInc() || n.isDec()) {
                if (NodeUtil.isExpressionNode(parent)) {
                    parent.replaceChild(n, new Node(122, Node.newNumber(0.0).copyInformationFrom(n)));
                } else if (n.isComma() && n != parent.getLastChild()) {
                    parent.removeChild(n);
                } else {
                    if (!parent.isFor() || NodeUtil.isForIn(parent) || NodeUtil.getConditionExpression(parent) == n) return;
                    parent.replaceChild(n, new Node(124));
                }
            } else {
                Preconditions.checkState((boolean)false, (Object)"Unknown statement");
            }
            this.compiler.reportCodeChange();
            return;
        }
        Node c = n.getFirstChild();
        while (c != null) {
            Node next = c.getNext();
            if (!ControlFlowGraph.isEnteringNewCfgNode(c)) {
                this.tryRemoveAssignment(t, c, exprRoot, state);
            }
            c = next;
        }
    }

    private boolean isVariableStillLiveWithinExpression(Node n, Node exprRoot, String variable) {
        while (n != exprRoot) {
            VariableLiveness state = VariableLiveness.MAYBE_LIVE;
            switch (n.getParent().getType()) {
                case 100: 
                case 101: {
                    if (n.getNext() == null || (state = this.isVariableReadBeforeKill(n.getNext(), variable)) != VariableLiveness.KILL) break;
                    state = VariableLiveness.MAYBE_LIVE;
                    break;
                }
                case 98: {
                    if (n.getNext() == null || n.getNext().getNext() == null) break;
                    state = this.checkHookBranchReadBeforeKill(n.getNext(), n.getNext().getNext(), variable);
                    break;
                }
                default: {
                    for (Node sibling = n.getNext(); sibling != null && (state = this.isVariableReadBeforeKill(sibling, variable)) == VariableLiveness.MAYBE_LIVE; sibling = sibling.getNext()) {
                    }
                }
            }
            if (state == VariableLiveness.READ) {
                return true;
            }
            if (state == VariableLiveness.KILL) {
                return false;
            }
            n = n.getParent();
        }
        return false;
    }

    private VariableLiveness isVariableReadBeforeKill(Node n, String variable) {
        if (ControlFlowGraph.isEnteringNewCfgNode(n)) {
            return VariableLiveness.MAYBE_LIVE;
        }
        if (n.isName() && variable.equals(n.getString())) {
            if (NodeUtil.isVarOrSimpleAssignLhs(n, n.getParent())) {
                Preconditions.checkState((boolean)n.getParent().isAssign());
                Node rhs = n.getNext();
                VariableLiveness state = this.isVariableReadBeforeKill(rhs, variable);
                if (state == VariableLiveness.READ) {
                    return state;
                }
                return VariableLiveness.KILL;
            }
            return VariableLiveness.READ;
        }
        switch (n.getType()) {
            case 100: 
            case 101: {
                VariableLiveness v1 = this.isVariableReadBeforeKill(n.getFirstChild(), variable);
                VariableLiveness v2 = this.isVariableReadBeforeKill(n.getLastChild(), variable);
                if (v1 != VariableLiveness.MAYBE_LIVE) {
                    return v1;
                }
                if (v2 == VariableLiveness.READ) {
                    return VariableLiveness.READ;
                }
                return VariableLiveness.MAYBE_LIVE;
            }
            case 98: {
                VariableLiveness first = this.isVariableReadBeforeKill(n.getFirstChild(), variable);
                if (first != VariableLiveness.MAYBE_LIVE) {
                    return first;
                }
                return this.checkHookBranchReadBeforeKill(n.getFirstChild().getNext(), n.getLastChild(), variable);
            }
        }
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            VariableLiveness state = this.isVariableReadBeforeKill(child, variable);
            if (state == VariableLiveness.MAYBE_LIVE) continue;
            return state;
        }
        return VariableLiveness.MAYBE_LIVE;
    }

    private VariableLiveness checkHookBranchReadBeforeKill(Node trueCase, Node falseCase, String variable) {
        VariableLiveness v1 = this.isVariableReadBeforeKill(trueCase, variable);
        VariableLiveness v2 = this.isVariableReadBeforeKill(falseCase, variable);
        if (v1 == VariableLiveness.READ || v2 == VariableLiveness.READ) {
            return VariableLiveness.READ;
        }
        if (v1 == VariableLiveness.KILL && v2 == VariableLiveness.KILL) {
            return VariableLiveness.KILL;
        }
        return VariableLiveness.MAYBE_LIVE;
    }

    private static enum VariableLiveness {
        MAYBE_LIVE,
        READ,
        KILL;

    }
}

