/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.ObjectType;
import javax.annotation.Nullable;

class InferJSDocInfo
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    private boolean inExterns;

    InferJSDocInfo(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        if (externs != null) {
            this.inExterns = true;
            NodeTraversal.traverse(this.compiler, externs, this);
        }
        if (root != null) {
            this.inExterns = false;
            NodeTraversal.traverse(this.compiler, root, this);
        }
    }

    @Override
    public void hotSwapScript(Node root, Node originalRoot) {
        Preconditions.checkNotNull((Object)root);
        Preconditions.checkState((boolean)root.isScript());
        this.inExterns = false;
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 38: {
                JSType varType;
                if (parent == null) {
                    return;
                }
                if (!(parent.getType() == 118 || NodeUtil.isFunctionDeclaration(parent) || parent.isAssign() && n == parent.getFirstChild())) {
                    return;
                }
                JSDocInfo docInfo = n.getJSDocInfo();
                if (docInfo == null && (!parent.isVar() || parent.hasOneChild())) {
                    docInfo = parent.getJSDocInfo();
                }
                if ((varType = n.getJSType()) == null && parent.isFunction()) {
                    varType = parent.getJSType();
                }
                if (varType == null || docInfo == null) {
                    return;
                }
                ObjectType objType = this.dereferenceToObject(varType);
                if (objType == null || objType.getJSDocInfo() != null) {
                    return;
                }
                this.attachJSDocInfoToNominalTypeOrShape(objType, docInfo, n.getString());
                break;
            }
            case 33: {
                ObjectType propType;
                ObjectType lhsType;
                if (!NodeUtil.isExpressionNode(parent) && (!parent.isAssign() || parent.getFirstChild() != n)) break;
                JSDocInfo docInfo = n.getJSDocInfo();
                if (docInfo == null) {
                    docInfo = parent.getJSDocInfo();
                }
                if (docInfo == null || (lhsType = this.dereferenceToObject(n.getFirstChild().getJSType())) == null) break;
                String propName = n.getLastChild().getString();
                if (lhsType.hasOwnProperty(propName)) {
                    lhsType.setPropertyJSDocInfo(propName, docInfo);
                }
                if ((propType = this.dereferenceToObject(lhsType.getPropertyType(propName))) == null) break;
                this.attachJSDocInfoToNominalTypeOrShape(propType, docInfo, n.getQualifiedName());
            }
        }
    }

    private ObjectType dereferenceToObject(JSType type) {
        return ObjectType.cast(type == null ? null : type.dereference());
    }

    private void attachJSDocInfoToNominalTypeOrShape(ObjectType objType, JSDocInfo docInfo, @Nullable String qName) {
        if (objType.isConstructor() || objType.isEnumType() || objType.isInterface()) {
            if (objType.hasReferenceName() && objType.getReferenceName().equals(qName)) {
                objType.setJSDocInfo(docInfo);
                if (objType.isConstructor() || objType.isInterface()) {
                    JSType.toMaybeFunctionType(objType).getInstanceType().setJSDocInfo(docInfo);
                } else if (objType instanceof EnumType) {
                    ((EnumType)objType).getElementsType().setJSDocInfo(docInfo);
                }
            }
        } else if (!objType.isNativeObjectType() && objType.isFunctionType()) {
            objType.setJSDocInfo(docInfo);
        }
    }
}

