/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.resolver;

import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.resolver.Resolver;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;

public class PageResolver {
    private Log LOG = ExoLogger.getLogger(PageResolver.class);
    private WikiService wService;
    private Resolver resolver;

    public PageResolver(WikiService wService) {
        this.wService = wService;
    }

    public void setResolverPlugin(ComponentPlugin plugin) throws Exception {
        this.resolver = (Resolver)plugin;
    }

    public WikiPageParams extractWikiPageParams(String requestURI, UserNode portalUserNode) {
        try {
            if (this.resolver != null) {
                WikiPageParams params = this.resolver.extractPageParams(requestURI, portalUserNode);
                return params;
            }
            this.LOG.error((Object)("Couldn't extract WikiPageParams for URI: " + requestURI + ". ResolverPlugin is not set!"));
            return new WikiPageParams();
        }
        catch (Exception e) {
            this.LOG.warn((Object)("Couldn't extract WikiPageParams for URI: " + requestURI), (Throwable)e);
            return new WikiPageParams();
        }
    }

    public Page resolve(String requestURI, UserNode portalUserNode) throws Exception {
        WikiPageParams params = this.extractWikiPageParams(requestURI, portalUserNode);
        if (params.getType() == null) {
            this.LOG.warn((Object)("Couldn't resolve URI: " + requestURI));
            return null;
        }
        Page page = this.wService.getPageById(params.getType(), params.getOwner(), params.getPageId());
        if (this.LOG.isTraceEnabled()) {
            String message = String.format("Resolved URL: %s. Page %s is returned when providing Params[Type: %s, Owner: %s, PageId: %s]", requestURI, page, params.getType(), params.getOwner(), params.getPageId());
            this.LOG.trace((Object)message);
        }
        return page;
    }
}

