/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.Hex;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSampleEncryptionBox
extends AbstractFullBox {
    int algorithmId = -1;
    int ivSize = -1;
    byte[] kid = null;
    List<Entry> entries = new LinkedList<Entry>();

    protected AbstractSampleEncryptionBox(String type) {
        super(type);
    }

    @Override
    protected void getContent(IsoOutputStream os) throws IOException {
        if (this.isOverrideTrackEncryptionBoxParameters()) {
            os.writeUInt24(this.algorithmId);
            os.writeUInt8(this.ivSize);
            os.write(this.kid);
        }
        os.writeUInt32(this.entries.size());
        for (Entry entry : this.entries) {
            os.write(entry.iv);
            if (!this.isSubSampleEncryption()) continue;
            os.writeUInt16(entry.pairs.size());
            for (Entry.Pair pair : entry.pairs) {
                os.writeUInt16(pair.clear);
                os.writeUInt32(pair.encrypted);
            }
        }
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        if ((this.getFlags() & 1) > 0) {
            this.algorithmId = in.readUInt24();
            this.ivSize = in.readUInt8();
            this.kid = in.read(16);
        }
        long numOfEntries = in.readUInt32();
        while (numOfEntries-- > 0L) {
            Entry e = new Entry();
            e.iv = in.read((this.getFlags() & 1) > 0 ? this.ivSize : 8);
            if ((this.getFlags() & 2) > 0) {
                int numOfPairs = in.readUInt16();
                while (numOfPairs-- > 0) {
                    e.pairs.add(new Entry.Pair(in.readUInt16(), in.readUInt32()));
                }
            }
            this.entries.add(e);
        }
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<Entry> entries) {
        this.entries = entries;
    }

    public int getAlgorithmId() {
        return this.algorithmId;
    }

    public void setAlgorithmId(int algorithmId) {
        this.algorithmId = algorithmId;
    }

    public int getIvSize() {
        return this.ivSize;
    }

    public void setIvSize(int ivSize) {
        this.ivSize = ivSize;
    }

    public byte[] getKid() {
        return this.kid;
    }

    public void setKid(byte[] kid) {
        this.kid = kid;
    }

    public boolean isSubSampleEncryption() {
        return this.entries.get((int)0).pairs.size() > 0;
    }

    public boolean isOverrideTrackEncryptionBoxParameters() {
        return this.kid != null && this.algorithmId > 0 && this.ivSize > 0;
    }

    @Override
    protected long getContentSize() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.getContent(new IsoOutputStream(baos));
        }
        catch (IOException e) {
            return -1L;
        }
        return baos.toByteArray().length;
    }

    @Override
    public void getBox(IsoOutputStream os) throws IOException {
        this.setFlags(0);
        if (this.isOverrideTrackEncryptionBoxParameters()) {
            this.setFlags(this.getFlags() | 1);
        }
        if (this.isSubSampleEncryption()) {
            this.setFlags(this.getFlags() | 2);
        }
        super.getBox(os);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractSampleEncryptionBox that = (AbstractSampleEncryptionBox)o;
        if (this.algorithmId != that.algorithmId) {
            return false;
        }
        if (this.ivSize != that.ivSize) {
            return false;
        }
        if (this.entries != null ? !((Object)this.entries).equals(that.entries) : that.entries != null) {
            return false;
        }
        return Arrays.equals(this.kid, that.kid);
    }

    public int hashCode() {
        int result = this.algorithmId;
        result = 31 * result + this.ivSize;
        result = 31 * result + (this.kid != null ? Arrays.hashCode(this.kid) : 0);
        result = 31 * result + (this.entries != null ? ((Object)this.entries).hashCode() : 0);
        return result;
    }

    public static class Entry {
        public byte[] iv;
        public List<Pair> pairs = new LinkedList<Pair>();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (!Arrays.equals(this.iv, entry.iv)) {
                return false;
            }
            return !(this.pairs != null ? !((Object)this.pairs).equals(entry.pairs) : entry.pairs != null);
        }

        public int hashCode() {
            int result = this.iv != null ? Arrays.hashCode(this.iv) : 0;
            result = 31 * result + (this.pairs != null ? ((Object)this.pairs).hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Entry{iv=" + Hex.encodeHex(this.iv) + ", pairs=" + this.pairs + '}';
        }

        public static class Pair {
            public int clear;
            public long encrypted;

            public Pair(int clear, long encrypted) {
                this.clear = clear;
                this.encrypted = encrypted;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Pair pair = (Pair)o;
                if (this.clear != pair.clear) {
                    return false;
                }
                return this.encrypted == pair.encrypted;
            }

            public int hashCode() {
                int result = this.clear;
                result = 31 * result + (int)(this.encrypted ^ this.encrypted >>> 32);
                return result;
            }

            public String toString() {
                return "clr:" + this.clear + " enc:" + this.encrypted;
            }
        }
    }
}

