/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.wordnet;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

public final class SynExpand {
    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("java org.apache.lucene.wordnet.SynExpand <index path> <query>");
        }
        FSDirectory directory = FSDirectory.open((File)new File(args[0]));
        IndexSearcher searcher = new IndexSearcher((Directory)directory, true);
        String query = args[1];
        String field = "contents";
        Query q = SynExpand.expand(query, (Searcher)searcher, (Analyzer)new StandardAnalyzer(Version.LUCENE_CURRENT), field, 0.9f);
        System.out.println("Query: " + q.toString(field));
        searcher.close();
        directory.close();
    }

    public static Query expand(String query, Searcher syns, Analyzer a, String f, final float boost) throws IOException {
        String field;
        final HashSet<String> already = new HashSet<String>();
        LinkedList<String> top = new LinkedList<String>();
        String string = field = f == null ? "contents" : f;
        if (a == null) {
            a = new StandardAnalyzer(Version.LUCENE_CURRENT);
        }
        TokenStream ts = a.reusableTokenStream(field, (Reader)new StringReader(query));
        CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
        ts.reset();
        while (ts.incrementToken()) {
            String word = termAtt.toString();
            if (!already.add(word)) continue;
            top.add(word);
        }
        ts.end();
        ts.close();
        final BooleanQuery tmp = new BooleanQuery();
        for (String word : top) {
            TermQuery tq = new TermQuery(new Term(field, word));
            tmp.add((Query)tq, BooleanClause.Occur.SHOULD);
            syns.search((Query)new TermQuery(new Term("word", word)), new Collector(){
                IndexReader reader;

                public boolean acceptsDocsOutOfOrder() {
                    return true;
                }

                public void collect(int doc) throws IOException {
                    Document d = this.reader.document(doc);
                    String[] values = d.getValues("syn");
                    for (int j = 0; j < values.length; ++j) {
                        String syn = values[j];
                        if (!already.add(syn)) continue;
                        TermQuery tq = new TermQuery(new Term(field, syn));
                        if (boost > 0.0f) {
                            tq.setBoost(boost);
                        }
                        tmp.add((Query)tq, BooleanClause.Occur.SHOULD);
                    }
                }

                public void setNextReader(IndexReader reader, int docBase) throws IOException {
                    this.reader = reader;
                }

                public void setScorer(Scorer scorer) throws IOException {
                }
            });
        }
        return tmp;
    }
}

