/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.extensions.publication;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.jcr.Node;
import javax.jcr.lock.Lock;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.extensions.publication.context.impl.ContextConfig;
import org.exoplatform.services.wcm.extensions.publication.impl.PublicationManagerImpl;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.impl.LifecyclesConfig;
import org.exoplatform.services.wcm.extensions.utils.ContextComparator;
import org.exoplatform.services.wcm.publication.WebpagePublicationPlugin;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class WCMPublicationServiceImpl
extends org.exoplatform.services.wcm.publication.WCMPublicationServiceImpl {
    private static final Log LOG = ExoLogger.getLogger((String)WCMPublicationServiceImpl.class.getName());
    private String publicationLocation = "collaboration:/";
    private String[] notAllowChildNodeEnrollInPubliction = new String[]{"exo:webContent"};

    public WCMPublicationServiceImpl(InitParams initParams) {
        this.publicationService = (PublicationService)WCMCoreUtils.getService(PublicationService.class);
        if (initParams.getValueParam("publicationLocation") != null) {
            this.publicationLocation = initParams.getValueParam("publicationLocation").getValue();
        }
        if (initParams.getValueParam("notAllowChildNodeEnrollInPubliction") != null && initParams.getValueParam("notAllowChildNodeEnrollInPubliction").getValue().indexOf(";") > -1) {
            this.notAllowChildNodeEnrollInPubliction = initParams.getValueParam("notAllowChildNodeEnrollInPubliction").getValue().split(";");
        }
    }

    public void enrollNodeInLifecycle(Node node, String siteName, String remoteUser) {
        block12: {
            try {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)(node.getPath() + "::" + siteName + "::" + remoteUser));
                }
                PublicationManagerImpl publicationManagerImpl = (PublicationManagerImpl)WCMCoreUtils.getService(PublicationManagerImpl.class);
                ContextComparator comparator = new ContextComparator();
                TreeSet<ContextConfig.Context> treeSetContext = new TreeSet<ContextConfig.Context>(comparator);
                treeSetContext.addAll(publicationManagerImpl.getContexts());
                for (ContextConfig.Context context : treeSetContext) {
                    boolean pathVerified = true;
                    boolean nodetypeVerified = true;
                    boolean siteVerified = true;
                    boolean membershipVerified = true;
                    String path = context.getPath();
                    String nodetype = context.getNodetype();
                    String site = context.getSite();
                    ArrayList<String> memberships = new ArrayList<String>();
                    if (context.getMembership() != null) {
                        memberships.add(context.getMembership());
                    }
                    if (context.getMemberships() != null) {
                        memberships.addAll(context.getMemberships());
                    }
                    if (path != null) {
                        String workspace = node.getSession().getWorkspace().getName();
                        ManageableRepository manaRepository = (ManageableRepository)node.getSession().getRepository();
                        String repository = manaRepository.getConfiguration().getName();
                        String[] pathTab = path.split(":");
                        boolean bl = pathVerified = node.getPath().contains(pathTab[2]) && repository.equals(pathTab[0]) && workspace.equals(pathTab[1]);
                    }
                    if (nodetype != null) {
                        nodetypeVerified = nodetype.equals(node.getPrimaryNodeType().getName());
                    }
                    if (site != null) {
                        siteVerified = site.equals(siteName);
                    }
                    if (memberships.size() > 0) {
                        for (String membership : memberships) {
                            String[] membershipTab = membership.split(":");
                            IdentityRegistry identityRegistry = (IdentityRegistry)WCMCoreUtils.getService(IdentityRegistry.class);
                            Identity identity = identityRegistry.getIdentity(remoteUser);
                            membershipVerified = identity.isMemberOf(membershipTab[1], membershipTab[0]);
                            if (!membershipVerified) continue;
                            break;
                        }
                    }
                    if (!pathVerified || !nodetypeVerified || !siteVerified || !membershipVerified) continue;
                    LifecyclesConfig.Lifecycle lifecycle = publicationManagerImpl.getLifecycle(context.getLifecycle());
                    String lifecycleName = ((WebpagePublicationPlugin)this.getWebpagePublicationPlugins().get(lifecycle.getPublicationPlugin())).getLifecycleName();
                    if (node.canAddMixin("publication:authoring")) {
                        node.addMixin("publication:authoring");
                        node.setProperty("publication:lastUser", remoteUser);
                        node.setProperty("publication:lifecycle", lifecycle.getName());
                        node.getSession().save();
                    }
                    this.enrollNodeInLifecycle(node, lifecycleName);
                    this.setInitialState(node, lifecycle, remoteUser);
                    break;
                }
            }
            catch (Exception ex) {
                if (!LOG.isErrorEnabled()) break block12;
                LOG.error((Object)"Couldn't complete the enrollement : ", (Throwable)ex);
            }
        }
    }

    private void setInitialState(Node node, LifecyclesConfig.Lifecycle lifecycle, String remoteUser) throws Exception {
        block10: {
            List<LifecyclesConfig.State> states = lifecycle.getStates();
            if (states == null || states.size() <= 0) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("could not find an initial state in lifecycle " + lifecycle.getName()));
                }
            } else {
                String initialState = states.get(0).getState();
                PublicationPlugin publicationPlugin = (PublicationPlugin)this.publicationService.getPublicationPlugins().get("Authoring publication");
                HashMap<String, String> context = new HashMap<String, String>();
                NodeLocation currentRevisionLocation = NodeLocation.getNodeLocationByNode((Node)node);
                Node currentRevision = this.getCurrentRevision(currentRevisionLocation);
                if (currentRevision != null) {
                    context.put("Publication.context.currentVersion", currentRevision.getName());
                }
                try {
                    if (node.isLocked()) {
                        Lock lock = node.getLock();
                        String owner = lock.getLockOwner();
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)"node is locked by owner, unlocking it for enrollement");
                        }
                        if (node.holdsLock() && remoteUser.equals(owner)) {
                            String lockToken = LockUtil.getLockToken((Node)node);
                            if (lockToken != null) {
                                node.getSession().addLockToken(lockToken);
                            }
                            node.unlock();
                            node.removeMixin("mix:lockable");
                            node.getSession().save();
                            LockUtil.removeLock((Node)node);
                        }
                    }
                    context.put("Publication.context.isInitialPhase", "true");
                    publicationPlugin.changeState(node, initialState, context);
                    node.setProperty("publication:lastUser", remoteUser);
                    node.getSession().save();
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block10;
                    LOG.error((Object)"Error setting staged state : ", (Throwable)e);
                }
            }
        }
    }

    public Node getCurrentRevision(NodeLocation currentRevisionLocation) {
        return NodeLocation.getNodeByLocation((NodeLocation)currentRevisionLocation);
    }

    public void updateLifecyleOnChangeContent(Node node, String siteName, String remoteUser, String newState) throws Exception {
        if (!node.getPath().startsWith(this.publicationLocation.split(":")[1])) {
            return;
        }
        if (node.getPrimaryNodeType().getName().equals("nt:file")) {
            for (String nodeType : this.notAllowChildNodeEnrollInPubliction) {
                if (this.allowEnrollInPublication(node, nodeType)) continue;
                return;
            }
        }
        if (!this.publicationService.isNodeEnrolledInLifecycle(node)) {
            this.enrollNodeInLifecycle(node, siteName, remoteUser);
        }
        String lifecycleName = this.publicationService.getNodeLifecycleName(node);
        WebpagePublicationPlugin publicationPlugin = (WebpagePublicationPlugin)this.getWebpagePublicationPlugins().get(lifecycleName);
        publicationPlugin.updateLifecyleOnChangeContent(node, remoteUser, newState);
        this.listenerService.broadcast("WCMPublicationService.event.updateState", (Object)this.cmsService, (Object)node);
    }

    private boolean allowEnrollInPublication(Node node, String nodeType) throws Exception {
        String path = node.getPath();
        Node parentNode = node.getParent();
        while (!path.equals("/") && path.length() > 0) {
            parentNode = (Node)node.getSession().getItem(path);
            if (parentNode.isNodeType(nodeType)) {
                return false;
            }
            path = StringUtils.substringBefore((String)path, (String)path.substring(path.lastIndexOf("/"), path.length()));
        }
        return true;
    }
}

