/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.management.operations.site;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.exoplatform.portal.mop.management.operations.site.AbstractSiteOperationHandler;
import org.gatein.management.api.exceptions.OperationException;
import org.gatein.management.api.exceptions.ResourceNotFoundException;
import org.gatein.management.api.operation.OperationContext;
import org.gatein.management.api.operation.ResultHandler;
import org.gatein.management.api.operation.model.ReadResourceModel;
import org.gatein.mop.api.workspace.Navigation;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.Page;
import org.gatein.mop.api.workspace.Site;

public class SiteReadResource
extends AbstractSiteOperationHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void execute(OperationContext operationContext, ResultHandler resultHandler, Site site) throws ResourceNotFoundException, OperationException {
        Navigation defaultNav;
        boolean pageOrNav = false;
        LinkedHashSet<String> children = new LinkedHashSet<String>(3);
        Page pages = site.getRootPage().getChild("pages");
        if (pages != null && !pages.getChildren().isEmpty()) {
            children.add("pages");
            pageOrNav = true;
        }
        if ((defaultNav = site.getRootNavigation().getChild("default")) != null && !defaultNav.getChildren().isEmpty()) {
            children.add("navigation");
            pageOrNav = true;
        }
        if (site.getObjectType() != ObjectType.GROUP_SITE || pageOrNav) {
            if (site.getObjectType() == ObjectType.PORTAL_SITE) {
                children.add("portal");
            } else if (site.getObjectType() == ObjectType.GROUP_SITE) {
                children.add("group");
            } else {
                if (site.getObjectType() != ObjectType.USER_SITE) throw new OperationException(operationContext.getOperationName(), "Unknown site type " + site.getObjectType());
                children.add("user");
            }
        } else if (site.getObjectType() == ObjectType.GROUP_SITE) {
            Collection groupsites = site.getWorkspace().getSites(site.getObjectType());
            for (Site groupsite : groupsites) {
                int index;
                String groupName;
                String siteName = site.getName();
                if (siteName.equals(groupName = groupsite.getName()) || (index = groupName.indexOf(siteName)) != 0) continue;
                children.add(groupName.substring(siteName.length(), groupName.length()));
            }
        }
        resultHandler.completed((Object)new ReadResourceModel("Available artifacts for site " + this.getSiteKey(site), children));
    }
}

