/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.processor;

import java.util.LinkedHashMap;
import java.util.Map;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;

public class I18NActivityUtils {
    private static final String RESOURCE_BUNDLE_VALUES_PARAM = "RESOURCE_BUNDLE_VALUES_PARAM";
    private static final String RESOURCE_BUNDLE_VALUES_CHARACTER = "#";
    private static final String RESOURCE_BUNDLE_ESCAPE_CHARACTER = "${_}";
    private static final String RESOURCE_BUNDLE_ESCAPE_KEY_CHARACTER = "${-}";
    private static final String RESOURCE_BUNDLE_KEYS_CHARACTER = ",";

    public static boolean isProcessMultiKeys(ExoSocialActivity activity) {
        String[] got = I18NActivityUtils.getResourceKeys(activity);
        return got.length > 1;
    }

    public static String[] getParamValues(String valueParam) {
        if (valueParam == null) {
            return null;
        }
        String[] got = valueParam.split(RESOURCE_BUNDLE_VALUES_CHARACTER);
        for (int i = 0; i < got.length; ++i) {
            got[i] = I18NActivityUtils.postProcess(got[i].trim());
        }
        return got;
    }

    public static String[] getResourceKeys(ExoSocialActivity activity) {
        String resourceKeys = activity.getTitleId();
        String[] got = resourceKeys.split(RESOURCE_BUNDLE_KEYS_CHARACTER);
        return got;
    }

    public static String[] getResourceValues(ExoSocialActivity activity) {
        Map params = activity.getTemplateParams();
        if (params == null) {
            return null;
        }
        String v = (String)params.get(RESOURCE_BUNDLE_VALUES_PARAM);
        String[] got = v.split(RESOURCE_BUNDLE_KEYS_CHARACTER);
        for (int i = 0; i < got.length; ++i) {
            got[i] = I18NActivityUtils.postKeyProcess(got[i].trim());
        }
        return got;
    }

    public static void addResourceKey(ExoSocialActivity activity, String key, String ... values) {
        String titleId;
        if (activity == null) {
            return;
        }
        LinkedHashMap<String, String> params = activity.getTemplateParams();
        if (params == null) {
            params = new LinkedHashMap<String, String>();
        }
        if ((titleId = activity.getTitleId()) != null) {
            activity.setTitleId(String.format("%s,%s", titleId, key));
        } else {
            activity.setTitleId(key);
        }
        String newValue = I18NActivityUtils.transformValuesToString(values);
        String oldValue = (String)params.get(RESOURCE_BUNDLE_VALUES_PARAM);
        if (oldValue != null || titleId != null) {
            String s = String.format("%s,%s", oldValue, newValue);
            params.put(RESOURCE_BUNDLE_VALUES_PARAM, s);
        } else {
            params.put(RESOURCE_BUNDLE_VALUES_PARAM, newValue);
        }
        activity.setTemplateParams(params);
    }

    private static String postProcess(String value) {
        return value.replace(RESOURCE_BUNDLE_ESCAPE_CHARACTER, RESOURCE_BUNDLE_VALUES_CHARACTER);
    }

    private static String preKeyProcess(String value) {
        return value.replace(RESOURCE_BUNDLE_KEYS_CHARACTER, RESOURCE_BUNDLE_ESCAPE_KEY_CHARACTER);
    }

    private static String postKeyProcess(String value) {
        return value.replace(RESOURCE_BUNDLE_ESCAPE_KEY_CHARACTER, RESOURCE_BUNDLE_KEYS_CHARACTER);
    }

    private static String preProcess(String value) {
        return value.replace(RESOURCE_BUNDLE_VALUES_CHARACTER, RESOURCE_BUNDLE_ESCAPE_CHARACTER);
    }

    private static String transformValuesToString(String ... values) {
        if (values == null) {
            return " ";
        }
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (String s : values) {
            if (s == null || s.length() == 0) {
                sb.append(" ");
            } else {
                s = I18NActivityUtils.preProcess(s);
                s = I18NActivityUtils.preKeyProcess(s);
                sb.append(s);
            }
            if (++count >= values.length) continue;
            sb.append(RESOURCE_BUNDLE_VALUES_CHARACTER);
        }
        return sb.toString();
    }
}

