/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.search;

import java.util.Collection;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.chromattic.api.ChromatticSession;
import org.exoplatform.commons.api.search.SearchServiceConnector;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.lifecycle.SocialChromatticLifeCycle;
import org.exoplatform.social.core.chromattic.entity.ProviderRootEntity;
import org.exoplatform.social.core.search.SocialSearchConnectorException;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.storage.query.JCRProperties;

public abstract class AbstractSocialSearchConnector
extends SearchServiceConnector {
    private static final Log LOG = ExoLogger.getLogger(AbstractSocialSearchConnector.class);

    public AbstractSocialSearchConnector(InitParams initParams) {
        super(initParams);
    }

    public final Collection<SearchResult> search(SearchContext context, String query, Collection<String> sites, int offset, int limit, String sort, String order) {
        Sorting.SortBy sortBy = null;
        if ("relevancy".equalsIgnoreCase(sort)) {
            sortBy = Sorting.SortBy.RELEVANCY;
        } else if ("date".equalsIgnoreCase(sort)) {
            sortBy = Sorting.SortBy.DATE;
        } else if ("title".equalsIgnoreCase(sort)) {
            sortBy = Sorting.SortBy.TITLE;
        } else {
            throw new SocialSearchConnectorException("sort must be relevancy, date or title but is : " + sort);
        }
        Sorting.OrderBy orderBy = null;
        if ("ASC".equalsIgnoreCase(order)) {
            orderBy = Sorting.OrderBy.ASC;
        } else if ("DESC".equalsIgnoreCase(order)) {
            orderBy = Sorting.OrderBy.DESC;
        } else {
            throw new SocialSearchConnectorException("sort must be ASC or DESC but is : " + order);
        }
        return this.search(context, query, new Range(offset, limit), new Sorting(sortBy, orderBy));
    }

    protected RowIterator rows(String statement) throws Exception {
        QueryManager queryMgr = this.getJCRSession().getWorkspace().getQueryManager();
        Query query = queryMgr.createQuery(statement, "sql");
        return query.execute().getRows();
    }

    private SocialChromatticLifeCycle lifecycleLookup() {
        PortalContainer container = PortalContainer.getInstance();
        ChromatticManager manager = (ChromatticManager)container.getComponentInstanceOfType(ChromatticManager.class);
        return (SocialChromatticLifeCycle)manager.getLifeCycle("soc");
    }

    private Session getJCRSession() {
        return this.lifecycleLookup().getSession().getJCRSession();
    }

    private ChromatticSession getSession() {
        return this.lifecycleLookup().getSession();
    }

    protected RowIterator rows(String statement, long offset, long limit) {
        if (statement == null) {
            return null;
        }
        try {
            QueryManager queryMgr = this.getJCRSession().getWorkspace().getQueryManager();
            Query query = queryMgr.createQuery(statement, "sql");
            if (query instanceof QueryImpl) {
                QueryImpl impl = (QueryImpl)query;
                impl.setOffset(offset);
                impl.setLimit(limit);
                return impl.execute().getRows();
            }
            return query.execute().getRows();
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            return null;
        }
    }

    protected ProviderRootEntity getProviderRoot() {
        SocialChromatticLifeCycle lifeCycle = this.lifecycleLookup();
        if (lifeCycle.getProviderRoot().get() == null) {
            lifeCycle.getProviderRoot().set(this.getRoot("soc:providers", ProviderRootEntity.class));
        }
        return (ProviderRootEntity)lifeCycle.getProviderRoot().get();
    }

    private <T> T getRoot(String nodetypeName, Class<T> t) {
        Object got = this.getSession().findByPath(t, nodetypeName);
        if (got == null) {
            got = this.getSession().insert(t, nodetypeName);
        }
        return (T)got;
    }

    protected String getExcerpt(Row row) {
        if (row == null) {
            return null;
        }
        try {
            Value value = row.getValue(JCRProperties.JCR_EXCERPT.getName());
            return value.getString();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Excerpt is not found!");
            return null;
        }
    }

    protected long getRelevancy(Row row) {
        if (row == null) {
            return 0L;
        }
        try {
            Value value = row.getValue(JCRProperties.JCR_RELEVANCY.getName());
            return value.getLong();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Relevancy is not found!");
            return 0L;
        }
    }

    protected abstract Collection<SearchResult> search(SearchContext var1, String var2, Range var3, Sorting var4);

    protected final class Range {
        public final int offset;
        public final int limit;

        public Range(int offset, int limit) {
            if (offset < 0) {
                throw new SocialSearchConnectorException("minimum offset is 0");
            }
            if (limit < 1) {
                throw new SocialSearchConnectorException("minimum limit is 1");
            }
            this.offset = offset;
            this.limit = limit;
        }
    }
}

