/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache.selector;

import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.social.core.storage.cache.model.key.IdentityFilterKey;
import org.exoplatform.social.core.storage.cache.model.key.ListIdentitiesKey;
import org.exoplatform.social.core.storage.cache.model.key.ScopeCacheKey;
import org.exoplatform.social.core.storage.cache.selector.ScopeCacheSelector;

public class IdentityCacheSelector
extends ScopeCacheSelector<ScopeCacheKey, Object> {
    private String provider;

    public IdentityCacheSelector(String provider) {
        if (provider == null) {
            throw new NullPointerException();
        }
        if (!provider.equals("organization") && !provider.equals("space")) {
            throw new IllegalArgumentException();
        }
        this.provider = provider;
    }

    @Override
    public boolean select(ScopeCacheKey key, ObjectCacheInfo<? extends Object> ocinfo) {
        if (!super.select(key, ocinfo)) {
            return false;
        }
        if (key instanceof IdentityFilterKey) {
            return ((IdentityFilterKey)key).getProviderId().equals("organization");
        }
        if (key instanceof ListIdentitiesKey) {
            return ((ListIdentitiesKey)key).getKey().getProviderId().equals("organization") || ((ListIdentitiesKey)key).getKey().getProviderId().equals("space");
        }
        return false;
    }
}

