/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.impl.ResourceConfig;
import org.exoplatform.services.cms.scripts.CmsScript;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.picocontainer.Startable;

public abstract class BaseResourceLoaderService
implements Startable {
    protected NodeHierarchyCreator nodeHierarchyCreator_;
    protected RepositoryService repositoryService_;
    protected ConfigurationManager cservice_;
    protected ExoCache<String, CmsScript> resourceCache_;
    private DMSConfiguration dmsConfiguration_;

    public BaseResourceLoaderService(ConfigurationManager cservice, NodeHierarchyCreator nodeHierarchyCreator, RepositoryService repositoryService, CacheService cacheService, DMSConfiguration dmsConfiguration) throws Exception {
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.repositoryService_ = repositoryService;
        this.cservice_ = cservice;
        this.resourceCache_ = cacheService.getCacheInstance(this.getClass().getName());
        this.dmsConfiguration_ = dmsConfiguration;
    }

    protected abstract String getBasePath();

    protected abstract void removeFromCache(String var1);

    public void start() {
    }

    public void stop() {
    }

    protected void init(Session session, ResourceConfig resourceConfig, String location) throws Exception {
        this.addScripts(session, resourceConfig.getRessources(), location);
    }

    protected void addScripts(Session session, List<ResourceConfig.Resource> resources, String location) throws Exception {
        String resourcesPath = this.getBasePath();
        if (resources.size() == 0) {
            return;
        }
        try {
            String firstResourceName = resources.get(0).getName();
            session.getItem(resourcesPath + "/" + firstResourceName);
            return;
        }
        catch (PathNotFoundException e) {
            Node root = session.getRootNode();
            Node resourcesHome = (Node)session.getItem(resourcesPath);
            String warPath = location + resourcesPath.substring(resourcesPath.lastIndexOf("/"));
            for (ResourceConfig.Resource resource : resources) {
                String name = resource.getName();
                String description = resource.getDescription();
                String path = warPath + "/" + name;
                InputStream in = this.cservice_.getInputStream(path);
                this.addResource(resourcesHome, name, description, in);
            }
            root.save();
            return;
        }
    }

    public void addResource(Node resourcesHome, String resourceName, InputStream in) throws Exception {
        this.addResource(resourcesHome, resourceName, resourceName, in);
    }

    public void addResource(Node resourcesHome, String resourceName, String resourceDescription, InputStream in) throws Exception {
        Node contentNode = null;
        if (resourceName.lastIndexOf("/") > -1) {
            Node parentResource;
            String realParenPath = StringUtils.substringBeforeLast((String)resourceName, (String)"/");
            resourcesHome = parentResource = resourcesHome.getNode(realParenPath);
            resourceName = StringUtils.substringAfterLast((String)resourceName, (String)"/");
        }
        try {
            Node script = resourcesHome.getNode(resourceName);
            contentNode = script.getNode("jcr:content");
            if (!contentNode.isCheckedOut()) {
                contentNode.checkout();
            }
        }
        catch (PathNotFoundException e) {
            Node script = resourcesHome.addNode(resourceName, "nt:file");
            contentNode = script.addNode("jcr:content", "exo:resources");
            contentNode.setProperty("jcr:encoding", "UTF-8");
            contentNode.setProperty("jcr:mimeType", "application/x-groovy");
        }
        contentNode.setProperty("jcr:data", in);
        contentNode.setProperty("dc:description", new String[]{resourceDescription});
        contentNode.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
        resourcesHome.save();
    }

    protected Node getResourcesHome(SessionProvider sessionProvider) throws Exception {
        ManageableRepository manageableRepository = null;
        manageableRepository = this.repositoryService_.getCurrentRepository();
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration_.getConfig();
        Session session = sessionProvider.getSession(dmsRepoConfig.getSystemWorkspace(), manageableRepository);
        String resourcesPath = this.getBasePath();
        return (Node)session.getItem(resourcesPath);
    }

    public String getResourceAsText(String resourceName) throws Exception {
        Node resourceNode = this.getResourceByName(resourceName);
        String text = resourceNode.getNode("jcr:content").getProperty("jcr:data").getString();
        return text;
    }

    public Node getResourceByName(String resourceName) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        Node resourcesHome = this.getResourcesHome(sessionProvider);
        return resourcesHome.getNode(resourceName);
    }

    public String getResourceNameByNodeType(NodeType nodeType) throws Exception {
        if (nodeType.isNodeType("exo:scriptAction")) {
            PropertyDefinition[] arrProperties;
            for (PropertyDefinition property : arrProperties = nodeType.getPropertyDefinitions()) {
                if (!property.getName().equals("exo:script")) continue;
                return property.getDefaultValues()[0].getString();
            }
        }
        return "";
    }

    public NodeType getNodeTypeByResourceName(String resourceName) throws Exception {
        ActionServiceContainer actionsServiceContainer = WCMCoreUtils.getService(ActionServiceContainer.class);
        Collection<NodeType> actionList = actionsServiceContainer.getCreatedActionTypes(WCMCoreUtils.getRepository().getConfiguration().getName());
        for (NodeType nodeType : actionList) {
            PropertyDefinition[] arrProperties;
            if (!nodeType.isNodeType("exo:scriptAction")) continue;
            for (PropertyDefinition property : arrProperties = nodeType.getPropertyDefinitions()) {
                if (!property.getName().equals("exo:script") || !property.getDefaultValues()[0].getString().equals(resourceName)) continue;
                return nodeType;
            }
        }
        return null;
    }

    public String getResourceDescription(String resourceName) throws Exception {
        Node resource = this.getResourceByName(resourceName);
        return resource.getNode("jcr:content").getProperty("dc:description").getValues()[0].getString();
    }

    public InputStream getResourceAsStream(String resourceName) throws Exception {
        Node resourceNode = this.getResourceByName(resourceName);
        InputStream stream = resourceNode.getNode("jcr:content").getProperty("jcr:data").getStream();
        return stream;
    }

    public NodeIterator getResources(SessionProvider sessionProvider) throws Exception {
        Node resourcesHome = this.getResourcesHome(sessionProvider);
        return resourcesHome.getNodes();
    }

    public boolean hasResources(SessionProvider sessionProvider) throws Exception {
        Node resourcesHome = this.getResourcesHome(sessionProvider);
        return resourcesHome.hasNodes();
    }

    public void addResource(String name, String text, SessionProvider provider) throws Exception {
        Node resourcesHome = this.getResourcesHome(provider);
        ByteArrayInputStream in = new ByteArrayInputStream(text.getBytes());
        this.addResource(resourcesHome, name, in);
        resourcesHome.save();
    }

    public void removeResource(String resourceName, SessionProvider provider) throws Exception {
        this.removeFromCache(resourceName);
        Node resourcesHome = this.getResourcesHome(provider);
        Node resource2remove = resourcesHome.getNode(resourceName);
        resource2remove.remove();
        resourcesHome.save();
    }
}

