/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.Reader;
import java.security.PrivilegedAction;
import java.util.Collections;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.util.Version;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingConfiguration;

public final class JcrStandartAnalyzer
extends Analyzer {
    private Analyzer defaultAnalyzer = (Analyzer)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Analyzer>(){

        @Override
        public Analyzer run() {
            return new StandardAnalyzer(Version.LUCENE_30, Collections.EMPTY_SET);
        }
    });
    private IndexingConfiguration indexingConfig;

    protected void setIndexingConfig(IndexingConfiguration indexingConfig) {
        this.indexingConfig = indexingConfig;
    }

    protected void setDefaultAnalyzer(Analyzer analyzer) {
        this.defaultAnalyzer = analyzer;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        Analyzer propertyAnalyzer;
        if (this.indexingConfig != null && (propertyAnalyzer = this.indexingConfig.getPropertyAnalyzer(fieldName)) != null) {
            return propertyAnalyzer.tokenStream(fieldName, reader);
        }
        return this.defaultAnalyzer.tokenStream(fieldName, reader);
    }
}

