/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.serialization;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectWriter;

public class ObjectWriterImpl
implements ObjectWriter {
    private final OutputStream out;

    public ObjectWriterImpl(OutputStream out) {
        this.out = new BufferedOutputStream(out, 2048);
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.out.write(v ? 1 : 0);
    }

    public void writeByte(byte b) throws IOException {
        this.out.write(b);
    }

    public void writeInt(int v) throws IOException {
        this.out.write(v >>> 24 & 0xFF);
        this.out.write(v >>> 16 & 0xFF);
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v >>> 0 & 0xFF);
    }

    public void writeLong(long v) throws IOException {
        byte[] writeBuffer = new byte[]{(byte)(v >>> 56), (byte)(v >>> 48), (byte)(v >>> 40), (byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
        this.out.write(writeBuffer, 0, 8);
    }

    public void writeString(String str) throws IOException {
        byte[] bytes = str.getBytes("UTF-8");
        this.writeInt(bytes.length);
        this.write(bytes);
    }

    public synchronized void writeStream(InputStream stream) throws IOException {
        throw new UnsupportedOperationException("Method is not supported");
    }
}

