/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.service;

import org.apache.commons.lang.StringUtils;
import org.exoplatform.faq.service.FAQNodeTypes;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.services.mail.Message;

public class MessageBuilder
implements FAQNodeTypes {
    private static final String MIMETYPE_TEXTHTML = "text/html".intern();
    private String questionLink;
    private String questionResponse;
    private String questionContent;
    private String questionDetail;
    private String questionOwner;
    private String questionEmail;
    private String categoryName;
    private String from;
    private String mimeType;
    private String subject;
    private String content;
    private TYPESEND type;

    public String getQuestionLink() {
        return this.questionLink;
    }

    public void setQuestionLink(String questionLink) {
        this.questionLink = questionLink;
    }

    public String getQuestionResponse() {
        return this.questionResponse;
    }

    public void setQuestionResponse(String questionResponse) {
        this.questionResponse = questionResponse;
    }

    public String getQuestionDetail() {
        return this.questionDetail;
    }

    public void setQuestionDetail(String questionDetail) {
        this.questionDetail = questionDetail;
    }

    public String getQuestionContent() {
        return this.questionContent;
    }

    public void setQuestionContent(String questionContent) {
        this.questionContent = questionContent;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getQuestionOwner() {
        return this.questionOwner;
    }

    public void setQuestionOwner(String questionOwner) {
        this.questionOwner = questionOwner;
    }

    public String getQuestionEmail() {
        return this.questionEmail;
    }

    public void setQuestionEmail(String questionEmail) {
        this.questionEmail = questionEmail;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = StringUtils.replace((String)content, (String)"&amp;", (String)"&");
    }

    public TYPESEND getType() {
        return this.type;
    }

    public void setType(TYPESEND type) {
        this.type = type;
    }

    public String getBody() {
        String body = StringUtils.replace((String)this.content, (String)"&categoryName_", (String)this.categoryName);
        if (this.type.equals((Object)TYPESEND.MOVE_QUESTION)) {
            if (!CommonUtils.isEmpty((String)this.questionDetail)) {
                this.questionContent = this.questionContent + "<br/> <span style=\"font-weight:normal\"> " + this.questionDetail + "</span>";
            }
        } else if (this.type.equals((Object)TYPESEND.NEW_QUESTION)) {
            body = StringUtils.replace((String)body, (String)"&questionResponse_", (String)this.questionResponse);
        }
        body = StringUtils.replace((String)body, (String)"&questionContent_", (String)this.questionContent);
        if (!CommonUtils.isEmpty((String)this.questionLink)) {
            if (this.questionLink.indexOf("http") == 0) {
                this.questionLink = this.questionLink.substring(this.questionLink.indexOf("/", 8));
            }
            this.questionLink = CommonUtils.getDomainURL() + this.questionLink;
        }
        body = StringUtils.replace((String)body, (String)"&questionLink_", (String)this.questionLink);
        body = StringUtils.replace((String)body, (String)"&answerNowLink_", (String)(this.questionLink + Utils.ANSWER_NOW + "true"));
        return StringUtils.replace((String)body, (String)"&", (String)"&amp;");
    }

    public Message getMessage() {
        Message message = new Message();
        message.setMimeType(MIMETYPE_TEXTHTML);
        message.setFrom(this.questionOwner);
        message.setSubject(CommonUtils.decodeSpecialCharToHTMLnumber((String)(this.subject + ": " + this.questionContent)));
        message.setBody(this.getBody());
        return message;
    }

    public static enum TYPESEND {
        NEW_QUESTION("new_question"),
        MOVE_QUESTION("move_question");

        private final String name;

        private TYPESEND(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

