/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.gadgets.services;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.UUID;
import org.exoplatform.application.gadget.Gadget;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Dashboard;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.mop.user.UserPortalContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UserDashboardConfigurationService {
    public static String DEFAULT_TAB_NAME;
    public static String DEFAULT_TAB_LABEL;
    private static String DASHBOARD_PAGE_TEMPLATE;
    private static String INVOLVED_USERS;
    private static final String SEPARATE_INVOLVED_USERS = "separate-users";
    private static final String ALL_INVOLVED_USERS = "all-users";
    private DataStorage dataStorageService = null;
    private UserPortalConfigService userPortalConfigService = null;
    private GadgetRegistryService gadgetRegistryService = null;
    private List<UserDashboardConfiguration> separateUsersconfig;
    private List<Gadget> allUsersConfig;
    private static final Log LOG;
    private static final UserPortalContext NULL_CONTEXT;

    public UserDashboardConfigurationService(DataStorage dataStorageService, UserPortalConfigService userPortalConfigService, GadgetRegistryService gadgetRegistryService, InitParams initParams) {
        DEFAULT_TAB_NAME = initParams.getValueParam("dashboardTabName").getValue();
        DEFAULT_TAB_LABEL = initParams.getValueParam("dashboardTabLabel").getValue();
        DASHBOARD_PAGE_TEMPLATE = initParams.getValueParam("dashboardPageTemplate").getValue();
        INVOLVED_USERS = initParams.getValueParam("involvedUsers").getValue();
        if (INVOLVED_USERS.equals(SEPARATE_INVOLVED_USERS)) {
            this.separateUsersconfig = initParams.getObjectParamValues(UserDashboardConfiguration.class);
            if (this.separateUsersconfig == null) {
                throw new IllegalStateException(INVOLVED_USERS + " is used for " + initParams.getValueParam("involvedUsers").getName() + " init param..\nObject param values can not be null..\nPlease check your configuration");
            }
        } else if (INVOLVED_USERS.equals(ALL_INVOLVED_USERS)) {
            this.allUsersConfig = initParams.getObjectParamValues(Gadget.class);
            if (this.allUsersConfig == null) {
                throw new IllegalStateException(INVOLVED_USERS + " is used for " + initParams.getValueParam("involvedUsers").getName() + " init param..\nObject param values can not be null..\nPlease check your configuration");
            }
        } else {
            throw new IllegalStateException(initParams.getValueParam("involvedUsers").getName() + " init param is missing.. Please check your configuration");
        }
        this.dataStorageService = dataStorageService;
        this.userPortalConfigService = userPortalConfigService;
        this.gadgetRegistryService = gadgetRegistryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepopulateUserDashboard(String userId) throws Exception {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            if (INVOLVED_USERS.equals(SEPARATE_INVOLVED_USERS)) {
                for (UserDashboardConfiguration userDashboardConfig : this.separateUsersconfig) {
                    if (!userId.equals(userDashboardConfig.getUserId())) continue;
                    LOG.info((Object)("Prepopulate the dashboard of user " + userId));
                    Page dashboardPage = this.getUserDashboardPage(userId);
                    if (dashboardPage != null) continue;
                    this.createUserDashboard(userId);
                    dashboardPage = this.getUserDashboardPage(userId);
                    this.configureUserDashboard(dashboardPage, userDashboardConfig.getGadgets());
                }
            } else {
                LOG.info((Object)("Prepopulate the dashboard of user " + userId));
                Page dashboardPage = this.getUserDashboardPage(userId);
                if (dashboardPage == null) {
                    this.createUserDashboard(userId);
                    dashboardPage = this.getUserDashboardPage(userId);
                    this.configureUserDashboard(dashboardPage, this.allUsersConfig);
                }
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private UserNavigation getUserNavigation(String userId) throws Exception {
        UserPortal userPortal = this.getUserPortal(userId);
        UserNavigation userNavigation = userPortal.getNavigation(SiteKey.user((String)userId));
        if (userNavigation == null) {
            try {
                this.userPortalConfigService.createUserSite(userId);
                userPortal = this.getUserPortal(userId);
                userNavigation = userPortal.getNavigation(SiteKey.user((String)userId));
            }
            catch (Exception e) {
                LOG.error((Object)("Could not create user site for user " + userId), (Throwable)e);
                throw e;
            }
        }
        return userNavigation;
    }

    private UserPortal getUserPortal(String userId) throws Exception {
        UserPortalConfig portalConfig = this.userPortalConfigService.getUserPortalConfig(this.userPortalConfigService.getDefaultPortal(), userId, NULL_CONTEXT);
        return portalConfig.getUserPortal();
    }

    private Page getUserDashboardPage(String userId) throws Exception {
        return this.dataStorageService.getPage(SiteType.USER.getName() + "::" + userId + "::" + DEFAULT_TAB_NAME);
    }

    private void createUserDashboard(String userId) {
        try {
            UserPortal userPortal = this.getUserPortal(userId);
            UserNavigation userNav = this.getUserNavigation(userId);
            if (userNav == null) {
                LOG.warn((Object)("User navigation for '" + userId + "' cannot be found. Cannot prePopulate gadgets in user's dashboard."));
                return;
            }
            SiteKey siteKey = userNav.getKey();
            Page page = this.userPortalConfigService.createPageTemplate(DASHBOARD_PAGE_TEMPLATE, siteKey.getTypeName(), siteKey.getName());
            page.setTitle(DEFAULT_TAB_NAME);
            page.setName(DEFAULT_TAB_NAME);
            this.dataStorageService.create(page);
            UserNode rootNode = userPortal.getNode(userNav, Scope.ALL, null, null);
            UserNode tabNode = rootNode.getChild(DEFAULT_TAB_NAME);
            if (tabNode == null) {
                tabNode = rootNode.addChild(DEFAULT_TAB_NAME);
                tabNode.setLabel(DEFAULT_TAB_NAME);
                tabNode.setPageRef(page.getPageKey());
                userPortal.saveNode(rootNode, null);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error while creating the user dashboard page for: " + userId), (Throwable)e);
        }
    }

    private void configureUserDashboard(Page userDashboardPage, List<Gadget> gadgets) {
        try {
            Application dashboardPortlet = (Application)userDashboardPage.getChildren().get(0);
            String dashboardId = dashboardPortlet.getStorageId();
            Dashboard dashboard = this.dataStorageService.loadDashboard(dashboardId);
            int colIndex = 0;
            for (Gadget gadget : gadgets) {
                Application gadgetApplication = Application.createGadgetApplication();
                gadgetApplication.setStorageName(UUID.randomUUID().toString());
                gadgetApplication.setState((ApplicationState)new TransientApplicationState(gadget.getName()));
                if (this.gadgetRegistryService.getGadget(gadget.getName()) == null) {
                    this.gadgetRegistryService.saveGadget(gadget);
                }
                Container column = (Container)dashboard.getChildren().get(colIndex);
                column.getChildren().add(gadgetApplication);
                colIndex = colIndex + 1 == dashboard.getChildren().size() ? 0 : colIndex + 1;
            }
            this.dataStorageService.saveDashboard(dashboard);
        }
        catch (Exception e) {
            LOG.error((Object)("Error while configuring the user dashboard for: " + userDashboardPage.getOwnerId()), (Throwable)e);
        }
    }

    static {
        LOG = ExoLogger.getExoLogger(UserDashboardConfigurationService.class);
        NULL_CONTEXT = new UserPortalContext(){

            public ResourceBundle getBundle(UserNavigation navigation) {
                return null;
            }

            public Locale getUserLocale() {
                return Locale.ENGLISH;
            }
        };
    }

    public static class UserDashboardConfiguration {
        private String userId;
        private List<Gadget> gadgets;

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public List<Gadget> getGadgets() {
            return this.gadgets;
        }

        public void setGadgets(List<Gadget> gadgets) {
            this.gadgets = gadgets;
        }
    }
}

